// notifyone6.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior A(in event e1, inout int x)
{
	void main(void)
	{
	int	i;

	for(i=0; i<100; i++)
	   { wait e1;
	     x++;
	    }
	}
};

behavior B(in event e2, inout int y)
{
	void main(void)
	{
	int	i;

	for(i=0; i<100; i++)
	   { wait e2;
	     y++;
	    }
	}
};

behavior C(out event e1, out event e2, in int x, in int y)
{
	void main(void)
	{
	int	i;

	for(i=0; i<10; i++)
	   { notifyone e1, e2;
	     waitfor(1);
	    }
	assert(x + y == 10);

	for(i=0; i<10; i++)
	   { notifyone e1, e2;
	     waitfor(1);
	    }
	assert(x + y == 20);

	for(i=0; i<10; i++)
	   { notifyone e1, e2;
	     waitfor(1);
	    }
	assert(x + y == 30);

	for(i=0; i<70; i++)
	   { notifyone e1, e2;
	     waitfor(1);
	    }
	assert(x + y == 100);

	for(i=0; i<100; i++)
	   { notifyone e1, e2;
	     waitfor(1);
	    }
	assert(x + y == 200);
	}
};

behavior Main
{
	event	e1, e2;
	int	x = 0;
	int	y = 0;
	A	a(e1, x);
	B	b(e2, y);
	C	c(e1, e2, x, y);

	int main(void)
	{
	puts("notifyone6: Starting...");

	par {	a.main();
		b.main();
		c.main();
		};
	assert(x + y == 200);
	assert(now() == 200);

	puts("notifyone6: Done.");
	return(0);
	}
};

// EOF
