// fsm5.sc

#include <stdio.h>
#include <assert.h>

behavior S1(inout int x)
{
	void main(void)
	{
	assert(x == 0);
	x = 1;
	}
};

behavior S2(inout int x)
{
	void main(void)
	{
	assert(x == 10);
	x = 11;
	}
};

behavior S3(inout int x)
{
	void main(void)
	{
	assert(x < 10);
	assert(x > 0);
	x++;
	}
};

behavior Main
{
	int	x = 0;
	S1	s1(x);
	S2	s2(x);
	S3	s3(x);

	int main(void)
	{
	puts("fsm5: Starting...");

	fsm { s1: goto s3;
	      s2: if (x < 0) goto s1;
		  if (x == 11) break;
		  goto s2;
	      s3: if (x < 10) goto s3;
		  goto s2;
	     };
	assert(x == 11);

	puts("fsm5: Done.");
	return(0);
	}
};

// EOF
