// try28.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior Try
{
	void main(void)
	{
	waitfor 10;
	}
};

behavior Interrupt(inout int x, in event e)
{
	void main(void)
	{
	x++;
	wait e;
	}
};

behavior Exception(inout int x, in event e)
{
	Try		t;
	Interrupt	i(x, e);

	void main(void)
	{
	try {	t.main();
		}
		interrupt e
		    {	i.main();
			};
	}
};

behavior Trigger(in int x, out event e)
{
	void main(void)
	{
	waitfor 3;
	notify e;
	waitfor 3;
	notify e;
	waitfor 3;
	notify e;
	waitfor 3;

	assert(x == 2);
	assert(now() == 12);
	puts("try28: Expecting deadlock... (Done.)");
	}
};

behavior Main
{
	event		e1;
	int		x = 0;

	Exception	e(x, e1);
	Trigger		t(x, e1);

	int main(void)
	{
	puts("try28: Starting...");

	par {	e.main();
		t.main();
		}

	assert(false);
	return(0);
	}
};

// EOF
