// try16.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior T0
{
	void main(void)
	{
	waitfor 10;
	}
};

behavior Empty
{
	void main(void)
	{
	}
};

behavior T1
{
	event		e1, e2, e3, e4;
	T0		t;
	Empty		ta,
			tb,
			ia,
			ib;

	void main(void)
	{
	try {	t.main();
		}
		trap e1
		    {	ta.main();
			}
		trap e2
		    {	tb.main();
			}
		interrupt e3
		    {	ia.main();
			}
		interrupt e4
		    {	ib.main();
			};
	}
};

behavior A1
{
	void main(void)
	{
	waitfor 10;
	}
};

behavior A
{
	A1	a1, a2;
	T1	t1;

	void main(void)
	{
	par {	a1.main();
		a2.main();
		t1.main();
		};
	}
};

behavior B1
{
	void main(void)
	{
	waitfor 10;
	}
};

behavior B2
{
	void main(void)
	{
	waitfor 2;
	}
};

behavior B31
{
	void main(void)
	{
	waitfor 1;
	}
};

behavior B32
{
	void main(void)
	{
	waitfor 2;
	}
};

behavior B3
{
	B31	b31;
	B32	b32;

	void main(void)
	{
	int i;
	pipe(i=0;i<4;i++)
	    {	b31.main();
		b32.main();
		};
	}
};

behavior B
{
	B1	b1;
	B2	b2;
	B3	b3;

	void main(void)
	{
	par {	b1.main();
		b2.main();
		b3.main();
		};
	}
};

behavior Try
{
	A	a;
	B	b;

	void main(void)
	{
	par {	a.main();
		b.main();
		};
	}
};

behavior TrapA(inout int x)
{
	void main(void)
	{
	x++;
	waitfor 1;
	}
};

behavior TrapB(inout int y)
{
	void main(void)
	{
	y++;
	waitfor 2;
	}
};

behavior InterruptA(inout int x)
{
	void main(void)
	{
	x++;
	waitfor 3;
	}
};

behavior InterruptB(inout int y)
{
	void main(void)
	{
	y++;
	waitfor 4;
	}
};

behavior Exception(inout int x, inout int y,
		in event e1, in event e2, in event e3, in event e4)
{
	Try		t;
	TrapA		ta(x);
	TrapB		tb(y);
	InterruptA	ia(x);
	InterruptB	ib(y);

	void main(void)
	{
	try {	t.main();
		}
		trap e1
		    {	ta.main();
			}
		trap e2
		    {	tb.main();
			}
		interrupt e3
		    {	ia.main();
			}
		interrupt e4
		    {	ib.main();
			};
	}
};

behavior Trigger(out event e)
{
	void main(void)
	{
	waitfor 5;
	notify e;
	}
};

behavior Main
{
	event		e1, e2, e3, e4, e5;
	int		x = 0;
	int		y = 0;

	Exception	e(x, y, e1, e2, e3, e4);
	Trigger		t1(e1),
			t2(e2),
			t3(e3),
			t4(e4),
			t5(e5);

	int main(void)
	{
	puts("try16: Starting...");

	par {	e.main();
		t1.main();
		}
	assert(x == 1);
	assert(y == 0);
	assert(now() == 6);

	par {	e.main();
		t2.main();
		}
	assert(x == 1);
	assert(y == 1);
	assert(now() == 13);

	par {	e.main();
		t3.main();
		}
	assert(x == 2);
	assert(y == 1);
	assert(now() == 26);

	par {	e.main();
		t4.main();
		}
	assert(x == 2);
	assert(y == 2);
	assert(now() == 40);

	par {	e.main();
		t5.main();
		}
	assert(x == 2);
	assert(y == 2);
	assert(now() == 50);

	puts("try16: Done.");
	return(0);
	}
};

// EOF
