// typed_queue_test1.sc: test bench for c_typed_queue.sh
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 04/25/03 RD	changed receiver interface to support array types
// 02/14/02 RD	applied naming convention, integrated with distribution
// 02/05/02 RD	initial version (type int, 1 sender, 1 receiver)


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>


#define QUEUE_SIZE	12	// length of the queue
#define N		100	// number of read and write transactions


import "c_int_queue";
//import "c_int_queue_dbg";	// use this to debug the channel!


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((unsigned int)(drand48() * (double)Range));
}


behavior QueueUser(
    i_int_tranceiver Queue)
{
    void SendData(int s)
    {
	int Data;

	printf("Time%4s: Queue user storing data %d.\n",
		time2str(now()), s);
	Data = s;
	Queue.send(Data);
    }

    void ReceiveData(int r)
    {
	int Data;

	printf("Time%4s: Queue user loading data %d.\n",
		time2str(now()), r);
	Queue.receive(&Data);
	assert(Data == r);
    }

    void main(void)
    {
	int i,
	    r = 0,
	    s = 0,
	    n = 0;

	for(i=0; i<2*N; i++)
	{
	    if (  (n > 0)	// can we receive?
		&&(r < N))
	    {
		if (  (n < QUEUE_SIZE) // can we send?
		    &&(s < N))
		{
		    if (Rnd(2))	// send or receive
		    {
			ReceiveData(++r);
			n--;
		    }
		    else
		    {
			SendData(++s);
			n++;
		    }
		}
		else	// must receive
		{
		    ReceiveData(++r);
		    n--;
		}
	    }
	    else	// must send
	    {
		SendData(++s);
		n++;
	    }
	    printf("Time%4s: Queue contains %d elements.\n",
			time2str(now()), n);
	}
	assert(r + s == i);
	assert(r == s);
	assert(n == 0);
    }
};


behavior Main			// test bench for typed_queue
{
    c_int_queue  Queue(((const unsigned long)QUEUE_SIZE));
    QueueUser    u1(Queue);

    int main(void)
    {
	printf("Time%4s: typed_queue_test1: Starting...\n",
		time2str(now()));
	printf("Time%4s: Running 1 tranceiver using data type 'int'.\n",
		time2str(now()));
	u1.main();
	printf("Time%4s: typed_queue_test1: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF typed_queue_test1.sc
