// alu.sc
// (last update: 02/22/02, RD)


behavior alu(
	in bit[31:0] a,
	in bit[31:0] b,
	in bit[3:0] ctrl,
	out bit[31:0] r)
{
  void main(void)
  {
    switch(ctrl)
    {
	case 0000b: r = a + b; break;
	case 0001b: r = a - b; break;
	case 0010b: r = a < b; break;
	case 0011b: r = a <= b; break;
	case 0100b: r = a > b; break;
	case 0101b: r = a >= b; break;
	case 0110b: r = a != b; break;
	case 0111b: r = a == b; break;
	case 1000b: r = a & b; break;
	case 1001b: r = a | b; break;
	case 1010b: r = a ^ b; break;
	case 1011b: r = !a; break;
	case 1100b: r = !b; break;
	case 1101b: r = ~a; break;
	case 1110b: r = ~b; break;
	default:    r = a; break;
    }
  }
};

// eof
