// Signal.sc (based on Piped.sc)
//
// purpose: testing the initialization of ordinary and 'signal' variables
//          (plus other features)
//
// 03/28/11 RD	added missing 'const' qualifier to avoid warnings
// 04/01/03 RD	added regression test for const array initialization bug
// 12/18/02 RD	created from Piped.sc


#include <string.h>
#include <assert.h>


/*** 'signal' variables in global scope ***/

int        g0 = 5;
signal int g1 = 5;
int        G0[10] = { 0,1,2,3,4,5,6,7,8,9 };
signal int G1[10] = { 0,1,2,3,4,5,6,7,8,9 };
int        G027[2][7] = { { 0, 1, 2, 3, 4, 5, 6},
			  {10,11,12,13,14,15,16} };
signal int G227[2][7] = { { 0, 1, 2, 3, 4, 5, 6},
			  {10,11,12,13,14,15,16} };
int        G0234[2][3][4] =
	{ { {   0,  1,  2,  3 },
	    {  10, 11, 12, 13 },
	    {  20, 21, 22, 23 } },
	  { { 100,101,102,103 },
	    { 110,111,112,113 },
	    { 120,121,122,123 } } };
signal int G1234[2][3][4] =
	{ { {   0,  1,  2,  3 },
	    {  10, 11, 12, 13 },
	    {  20, 21, 22, 23 } },
	  { { 100,101,102,103 },
	    { 110,111,112,113 },
	    { 120,121,122,123 } } };

const char  *gp1   = "abc";
char        gs1[4] = {'a', 'b', 'c'};
char        gs2[4] = "abc";
signal const char *gpp1 = "abc";
signal char gps1[4] = {'a', 'b', 'c'};
//signal char gps2[4] = "abc"; // warning: deprecated conversion from string constant to 'char*'
signal char gps2[4] = {'a', 'b', 'c'}; // this stays valid, though (RD, 3/28/11)


behavior Main
{
	/*** 'signal' variables in class scope ***/

	int        i0 = 5;
	signal int i1 = 5;
	int        I [10] = { 0,1,2,3,4,5,6,7,8,9 };
	signal int I1[10] = { 0,1,2,3,4,5,6,7,8,9 };
	signal int I2[10][10];
	signal int I3[10][10][10];

	const char *p1   = "abc";
	char       s1[4] = {'a', 'b', 'c'};
	char       s2[4] = "abc";
	signal const char *pp1 = "abc";
	signal char ps1[4] = {'a', 'b', 'c'};
	signal char ps2[4] = "abc";

//	no unspecified array size allowed for 'signal'!

	int main(void)
	{
		/*** 'signal' variables in local scope ***/

		int        l0 = 5;
		signal int l1 = 5;
		int        L0[10] = { 0,1,2,3,4,5,6,7,8,9 };
		signal int L1[10] = { 0,1,2,3,4,5,6,7,8,9 };
		int        L027[2][7] = { { 0, 1, 2, 3, 4, 5, 6},
					  {10,11,12,13,14,15,16} };
		signal int L227[2][7] = { { 0, 1, 2, 3, 4, 5, 6},
					  {10,11,12,13,14,15,16} };
		int        L0234[2][3][4] =
		{ { {   0,  1,  2,  3 },
		    {  10, 11, 12, 13 },
		    {  20, 21, 22, 23 } },
		  { { 100,101,102,103 },
		    { 110,111,112,113 },
		    { 120,121,122,123 } } };
		signal int L1234[2][3][4] =
		{ { {   0,  1,  2,  3 },
		    {  10, 11, 12, 13 },
		    {  20, 21, 22, 23 } },
		  { { 100,101,102,103 },
		    { 110,111,112,113 },
		    { 120,121,122,123 } } };

		const char  *lp1   = "abc";
		char        ls1[4] = {'a', 'b', 'c'};
		char        ls2[4] = "abc";
		signal const char *lpp1 = "abc";
		signal char lps1[4] = {'a', 'b', 'c'};
//		signal char lps2[4] = "abc"; // warning: deprecated conversion from string constant to 'char*'
		signal char lps2[4] = {'a', 'b', 'c'}; // this stays valid, though (RD, 3/28/11)


		// initialization tests

		assert(i0 == 5);
		assert(i1 == 5);

		assert(I[0] == 0);
		assert(I[1] == 1);
		assert(I[9] == 9);

		assert(I1[0] == 0);
		assert(I1[1] == 1);
		assert(I1[9] == 9);

		assert(l0 == 5);
		assert(l1 == 5);

		assert(L0[0] == 0);
		assert(L0[1] == 1);
		assert(L0[9] == 9);

		assert(L1[0] == 0);
		assert(L1[1] == 1);
		assert(L1[9] == 9);

		assert(L027[0][0] ==  0);
		assert(L027[0][1] ==  1);
		assert(L027[0][2] ==  2);
		assert(L027[1][0] == 10);
		assert(L027[1][1] == 11);
		assert(L027[1][6] == 16);

		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == 16);

		assert(L0234[0][0][0] ==   0);
		assert(L0234[1][0][0] == 100);
		assert(L0234[0][1][0] ==  10);
		assert(L0234[0][0][1] ==   1);
		assert(L0234[1][2][3] == 123);

		assert(L1234[0][0][0] ==   0);
		assert(L1234[1][0][0] == 100);
		assert(L1234[0][1][0] ==  10);
		assert(L1234[0][0][1] ==   1);
		assert(L1234[1][2][3] == 123);

		assert(g0 == 5);
		assert(g1 == 5);

		assert(G0[0] == 0);
		assert(G0[1] == 1);
		assert(G0[9] == 9);

		assert(G1[0] == 0);
		assert(G1[1] == 1);
		assert(G1[9] == 9);

		assert(G027[0][0] ==  0);
		assert(G027[0][1] ==  1);
		assert(G027[0][2] ==  2);
		assert(G027[1][0] == 10);
		assert(G027[1][1] == 11);
		assert(G027[1][6] == 16);

		assert(G227[0][0] ==  0);
		assert(G227[0][1] ==  1);
		assert(G227[0][2] ==  2);
		assert(G227[1][0] == 10);
		assert(G227[1][1] == 11);
		assert(G227[1][6] == 16);

		assert(G0234[0][0][0] ==   0);
		assert(G0234[1][0][0] == 100);
		assert(G0234[0][1][0] ==  10);
		assert(G0234[0][0][1] ==   1);
		assert(G0234[1][2][3] == 123);

		assert(G1234[0][0][0] ==   0);
		assert(G1234[1][0][0] == 100);
		assert(G1234[0][1][0] ==  10);
		assert(G1234[0][0][1] ==   1);
		assert(G1234[1][2][3] == 123);

		assert(0 == strcmp(p1, "abc"));
		assert(0 == strcmp(s1, "abc"));
		assert(0 == strcmp(s2, "abc"));
		assert(0 == strcmp(pp1, "abc"));
		assert(0 == strcmp(ps1, "abc"));
		assert(0 == strcmp(ps2, "abc"));

		assert(0 == strcmp(lp1, "abc"));
		assert(0 == strcmp(ls1, "abc"));
		assert(0 == strcmp(ls2, "abc"));
		assert(0 == strcmp(lpp1, "abc"));
		assert(0 == strcmp(lps1, "abc"));
		assert(0 == strcmp(lps2, "abc"));

		assert(0 == strcmp(gp1, "abc"));
		assert(0 == strcmp(gs1, "abc"));
		assert(0 == strcmp(gs2, "abc"));
		assert(0 == strcmp(gpp1, "abc"));
		assert(0 == strcmp(gps1, "abc"));
		assert(0 == strcmp(gps2, "abc"));


		// dynamic tests

		L0[1] = -1;
		L1[1] = -1;
		assert(L0[0] == 0);
		assert(L0[1] == -1);
		assert(L0[9] == 9);
		assert(L1[0] == 0);
		assert(L1[1] == 1);
		assert(L1[9] == 9);
		{ event e; notify e; wait e; }	/* update the signals once */
		assert(L0[0] == 0);
		assert(L0[1] == -1);
		assert(L0[9] == 9);
		assert(L1[0] == 0);
		assert(L1[1] == -1);
		assert(L1[9] == 9);

		L1[4] = L1[7];
		L1[7] = L1[4];
		assert(L1[0] == 0);
		assert(L1[1] == -1);
		assert(L1[4] == 4);
		assert(L1[7] == 7);
		assert(L1[9] == 9);
		{ event e; notify e; wait e; }	/* update the signals once */
		assert(L1[0] == 0);
		assert(L1[1] == -1);
		assert(L1[4] == 7);
		assert(L1[7] == 4);
		assert(L1[9] == 9);

		L227[0][1] = -1;
		L227[1][6] = -16;
		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == 16);
		{ event e; notify e; wait e; }	/* update the signals once */
		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  -1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == -16);

		L227[0][2] += L227[1][0];
		L227[1][1]++;
		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  -1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == -16);
		{ event e; notify e; wait e; }	/* update the signals once */
		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  -1);
		assert(L227[0][2] == 12);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 12);
		assert(L227[1][6] == -16);

		L1234[1][0][0] = 1;
		L1234[0][1][0]++;
		L1234[0][0][1] += L1234[1][0][0] + L1234[0][1][0];
		assert(L1234[0][0][0] ==   0);
		assert(L1234[1][0][0] == 100);
		assert(L1234[0][1][0] ==  10);
		assert(L1234[0][0][1] ==   1);
		assert(L1234[1][2][3] == 123);
		{ event e; notify e; wait e; }	/* update the signals once */
		assert(L1234[0][0][0] ==   0);
		assert(L1234[1][0][0] ==   1);
		assert(L1234[0][1][0] ==  11);
		assert(L1234[0][0][1] == 111);
		assert(L1234[1][2][3] == 123);

		return(0);
	}
};


// regression test for const array initialization
// (bug report 04/01/03 by Haobo Yu, fixed 04/02/03 by R.D.)

//#include<stdio.h>

int x;
const int a[3]={1,2,3};
//signal const int sa[3]={1,2,3};	// not allowed

behavior B1
{
    const int aa[3]={1,2,3};		// bug: assignment of read-only location
//  signal const int saa[3]={1,2,3};	// not allowed

    void main(void)
    {
     int i;
     const int aaa[3]={1,2,3};
//   signal const int saaa[3]={1,2,3};	// not allowed

     for(i=0;i<3;i++)
     {
//	printf("%d ",aa[i]);
	x += a[i];
	x += aa[i];
	x += aaa[i];
     }
    }
};

// eof
