// SigBus2.sc
//
// 03/20/03 RD	refinements
// 03/19/03 RD	initial version (based on SigBus.sc)

#include "../../inc/sim.sh"	// #include <sim.sh>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#define SIGNAL_EDGE	/* any event */
//#define SIGNAL_EDGE	rising
//#define SIGNAL_EDGE	falling

int Calls[2] = {0,0};

behavior NibbleStimulus(
	in int Delay,
	inout signal bit[4] Nibble)
{
    void main(void)
    {
	int i;

	Nibble = 0000b;
	for(i=0; i<5; i++)
	{
	    waitfor Delay;
	    Nibble = 0001b << i;
	}
	waitfor(10);
	assert(Calls[0] == Calls[1]);
	assert(Calls[0] == 9);	// byte value is assigned 9 times
	exit(0);	// terminate simulation now
    }
};

behavior ByteMonitor(
	in int Num,
	in signal bit[8] Byte,
	in signal bit[8] Comp)
{
    void main(void)
    {
	char	Buffer1[9],
		Buffer2[9];

	while(true)
	{
	    wait Byte SIGNAL_EDGE;
	    printf("ByteMonitor %d @ %2s: Byte is %s (should match %s)\n",
				Num,
				time2str(now()),
				ubit2str(2, &Buffer1[9], Byte),
				ubit2str(2, &Buffer2[9], Comp));
	    assert(Byte == Comp);
	    Calls[Num-1]++;
	}
    }
};

behavior Main
{
    signal bit[8] b = 10101010b;
    signal bit[4] n1 = 1010b, n2 = 1010b;

    NibbleStimulus s1(1, b[3:0]);
    NibbleStimulus s2(2, b[7:4]);
    ByteMonitor    m1(1, b, n2 @ n1);

    NibbleStimulus s3(1, n1);
    NibbleStimulus s4(2, n2);
    ByteMonitor    m2(2, n2 @ n1, b);

    int main(void)
    {
	par {	s1; s2; m1;
		s3; s4; m2;	}
	return(10);	// never reached
    }
};

// EOF
