// Piped.sc (was: tmp/tmpSC/piped.sc)
//
// purpose: testing the initialization of ordinary and 'piped' variables
//          (plus other features)
//
// 03/28/11 RD	added missing 'const' qualifiers to avoid warnings
// 03/27/02 RD	regression test for bug fix "piped array access"
// 03/28/02 RD	regression test for new feature "piped variable initialization"
// 03/28/02 RD	regression test for shifting in empty terminating pipelines
// 03/29/02 RD	regression test for new feature "complex member initialization"
// 03/29/02 RD	regression test for string initialization
// 03/29/02 RD	regression test for auto-size array initialization
// 07/18/02 RD	regression test for invalid open array


#include <string.h>
#include <assert.h>


/*** no 'piped' variables allowed in global scope! ***/


behavior Main
{
	/*** 'piped' variables in class scope ***/

	int       i0 = 5;
	piped int i1 = 5;
			// was: "Complex initializer not supported
			//       for class member '%s' (#2073)"
	int       I [10] = { 0,1,2,3,4,5,6,7,8,9 };
	piped int I1[10] = { 0,1,2,3,4,5,6,7,8,9 };
	piped int I2[10][10];
	piped int I3[10][10][10];

	const char *p1   = "abc";
	char       s1[4] = {'a', 'b', 'c'};
	char       s2[4] = "abc";
	char       s3[]  = {'a', 'b', 'c', 0};
	char       s4[]  = "abc";
	piped const char *pp1 = "abc";
	piped char ps1[4] = {'a', 'b', 'c'};
	piped char ps2[4] = "abc";
	piped char ps3[]  = {'a', 'b', 'c', 0};
	piped char ps4[]  = "abc";

	char       open_array[];	// valid (pointer)
//	piped char piped_open_array[];	// invalid! (07/18/02, RD)

	int main(void)
	{
		/*** 'piped' variables in local scope ***/

		int       i;
		int       l0 = 5;
		piped int l1 = 5;
		int       L0[10] = { 0,1,2,3,4,5,6,7,8,9 };
		piped int L1[10] = { 0,1,2,3,4,5,6,7,8,9 };
		int       L027[2][7] = {	{ 0, 1, 2, 3, 4, 5, 6},
						{10,11,12,13,14,15,16} };
		piped piped int L227[2][7] = {	{ 0, 1, 2, 3, 4, 5, 6},
						{10,11,12,13,14,15,16} };
		int       L0234[2][3][4] =
		{ { {   0,  1,  2,  3 },
		    {  10, 11, 12, 13 },
		    {  20, 21, 22, 23 } },
		  { { 100,101,102,103 },
		    { 110,111,112,113 },
		    { 120,121,122,123 } } };
		piped int L1234[2][3][4] =
		{ { {   0,  1,  2,  3 },
		    {  10, 11, 12, 13 },
		    {  20, 21, 22, 23 } },
		  { { 100,101,102,103 },
		    { 110,111,112,113 },
		    { 120,121,122,123 } } };

		const char *lp1   = "abc";
		char       ls1[4] = {'a', 'b', 'c'};
		char       ls2[4] = "abc";
		char       ls3[]  = {'a', 'b', 'c', 0};
		char       ls4[]  = "abc";
		piped const char *lpp1 = "abc";
		piped char lps1[4] = {'a', 'b', 'c'};
		piped char lps2[4] = "abc";
		piped char lps3[]  = {'a', 'b', 'c', 0};
		piped char lps4[]  = "abc";


		// initialization tests
		assert(i0 == 5);
		assert(i1 == 5);

		assert(I[0] == 0);
		assert(I[1] == 1);
		assert(I[9] == 9);

		assert(I1[0] == 0);
		assert(I1[1] == 1);
		assert(I1[9] == 9);

		assert(l0 == 5);
		assert(l1 == 5);

		assert(L0[0] == 0);
		assert(L0[1] == 1);
		assert(L0[9] == 9);

		assert(L1[0] == 0);
		assert(L1[1] == 1);
		assert(L1[9] == 9);

		assert(L027[0][0] ==  0);
		assert(L027[0][1] ==  1);
		assert(L027[0][2] ==  2);
		assert(L027[1][0] == 10);
		assert(L027[1][1] == 11);
		assert(L027[1][6] == 16);

		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == 16);

		assert(L0234[0][0][0] ==   0);
		assert(L0234[1][0][0] == 100);
		assert(L0234[0][1][0] ==  10);
		assert(L0234[0][0][1] ==   1);
		assert(L0234[1][2][3] == 123);

		assert(L1234[0][0][0] ==   0);
		assert(L1234[1][0][0] == 100);
		assert(L1234[0][1][0] ==  10);
		assert(L1234[0][0][1] ==   1);
		assert(L1234[1][2][3] == 123);

		assert(0 == strcmp(p1, "abc"));
		assert(0 == strcmp(s1, "abc"));
		assert(0 == strcmp(s2, "abc"));
		assert(0 == strcmp(s3, "abc"));
		assert(0 == strcmp(s4, "abc"));
		assert(0 == strcmp(pp1, "abc"));
		assert(0 == strcmp(ps1, "abc"));
		assert(0 == strcmp(ps2, "abc"));
		assert(0 == strcmp(ps3, "abc"));
		assert(0 == strcmp(ps4, "abc"));

		assert(0 == strcmp(lp1, "abc"));
		assert(0 == strcmp(ls1, "abc"));
		assert(0 == strcmp(ls2, "abc"));
		assert(0 == strcmp(ls3, "abc"));
		assert(0 == strcmp(ls4, "abc"));
		assert(0 == strcmp(lpp1, "abc"));
		assert(0 == strcmp(lps1, "abc"));
		assert(0 == strcmp(lps2, "abc"));
		assert(0 == strcmp(lps3, "abc"));
		assert(0 == strcmp(lps4, "abc"));

		// initial bug discovery
		i = 2;
		i += i * i;
		i = I[2];	// was bug: "invalid use of non-lvalue array!"
		I[3] = i;	// was bug: "invalid use of non-lvalue array!"

		// more complete test bench
		L0[1] = -1;
		L1[1] = -1;
		assert(L0[0] == 0);
		assert(L0[1] == -1);
		assert(L0[9] == 9);
		assert(L1[0] == 0);
		assert(L1[1] == 1);
		assert(L1[9] == 9);
		pipe(i=0; i<1; i++) { /* shift the pipes once */ }
		assert(L0[0] == 0);
		assert(L0[1] == -1);
		assert(L0[9] == 9);
		assert(L1[0] == 0);
		assert(L1[1] == -1);
		assert(L1[9] == 9);

		L1[4] = L1[7];
		L1[7] = L1[4];
		assert(L1[0] == 0);
		assert(L1[1] == -1);
		assert(L1[4] == 4);
		assert(L1[7] == 7);
		assert(L1[9] == 9);
		pipe(i=0; i<1; i++) { /* shift the pipes once */ }
		assert(L1[0] == 0);
		assert(L1[1] == -1);
		assert(L1[4] == 7);
		assert(L1[7] == 4);
		assert(L1[9] == 9);

		L227[0][1] = -1;
		L227[1][6] = -16;
		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == 16);
		pipe(i=0; i<1; i++) { /* shift the pipes once */ }
		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == 16);
		pipe(i=0; i<1; i++) { /* shift the pipes second time */ }
		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  -1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == -16);

		L227[0][2] += L227[1][0];
		L227[1][1]++;
		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  -1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == -16);
		pipe(i=0; i<1; i++) { /* shift the pipes once */ }
		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  -1);
		assert(L227[0][2] ==  2);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 11);
		assert(L227[1][6] == -16);
		pipe(i=0; i<1; i++) { /* shift the pipes second time */ }
		assert(L227[0][0] ==  0);
		assert(L227[0][1] ==  -1);
		assert(L227[0][2] == 12);
		assert(L227[1][0] == 10);
		assert(L227[1][1] == 12);
		assert(L227[1][6] == -16);

		L1234[1][0][0] = 1;
		L1234[0][1][0]++;
		L1234[0][0][1] += L1234[1][0][0] + L1234[0][1][0];
		assert(L1234[0][0][0] ==   0);
		assert(L1234[1][0][0] == 100);
		assert(L1234[0][1][0] ==  10);
		assert(L1234[0][0][1] ==   1);
		assert(L1234[1][2][3] == 123);
		pipe(i=0; i<1; i++) { /* shift the pipes once */ }
		assert(L1234[0][0][0] ==   0);
		assert(L1234[1][0][0] ==   1);
		assert(L1234[0][1][0] ==  11);
		assert(L1234[0][0][1] == 111);
		assert(L1234[1][2][3] == 123);

		return(0);
	}
};

// eof
