/************************************************************************/
/* List.cc: SpecC Internal Representation, List Template Class		*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 09/29/97 */
/************************************************************************/

/* last update: 06/15/04 */

/* modifications: (most recent first)
 *
 * 06/15/04 PC  Adjustments for scrc 2.0
 * 10/31/03 RD	added instantiations for StatePtr list
 * 09/12/03 RD	added instantiations for DelydAssgn and TmpVar lists
 * 02/04/03 RD	added instantiations for FsmdStmnt and FsmdState lists
 * 11/21/02 RD	added instantiations for event list
 * 05/29/01 RD	eliminated level 2 of SIR API
 * 05/29/01 RD	introduced this header (last update was 04/12/99)
 */

#include "IntRep/List.h"
#include "IntRep/Symbol.h"


/************************************************************************/
/*** instantiation of lists used in the SpecC internal representation ***/
/************************************************************************/


	/* fileinfo list */

template class SIR_List<sir_fileinfo>;
template class SIR_ListElem<sir_fileinfo>;


	/* import list */

template class SIR_List<sir_import>;
template class SIR_ListElem<sir_import>;


	/* note list */

template class SIR_List<sir_note>;
template class SIR_ListElem<sir_note>;


	/* initializer list */

template class SIR_List<sir_initializer>;
template class SIR_ListElem<sir_initializer>;


	/* parameter list */

template class SIR_List<sir_parameter>;
template class SIR_ListElem<sir_parameter>;


	/* port map list */

template class SIR_List<sir_portmap>;
template class SIR_ListElem<sir_portmap>;


	/* bit slice list */

template class SIR_List<sir_bitslice>;
template class SIR_ListElem<sir_bitslice>;


	/* type list */

template class SIR_List<sir_type>;
template class SIR_ListElem<sir_type>;


	/* type pointer list */

template class SIR_List<sir_type_ptr>;
template class SIR_ListElem<sir_type_ptr>;


	/* expression list */

template class SIR_List<sir_expression>;
template class SIR_ListElem<sir_expression>;


	/* constraint list */

template class SIR_List<sir_constraint>;
template class SIR_ListElem<sir_constraint>;


	/* transition list */

template class SIR_List<sir_transition>;
template class SIR_ListElem<sir_transition>;


	/* exception list */

template class SIR_List<sir_exception>;
template class SIR_ListElem<sir_exception>;


	/* label list */

template class SIR_List<sir_label>;
template class SIR_ListElem<sir_label>;


	/* statement list */

template class SIR_List<sir_statement>;
template class SIR_ListElem<sir_statement>;


	/* fsmd state list */

template class SIR_List<sir_fsmdstate>;
template class SIR_ListElem<sir_fsmdstate>;


	/* fsmd state pointer list */

template class SIR_List<sir_state_ptr>;
template class SIR_ListElem<sir_state_ptr>;


	/* fsmd statement list */

template class SIR_List<sir_fsmdstmnt>;
template class SIR_ListElem<sir_fsmdstmnt>;


	/* delayed assignment list */

template class SIR_List<sir_delydassgn>;
template class SIR_ListElem<sir_delydassgn>;


	/* temporary variable list */

template class SIR_List<sir_tmpvar>;
template class SIR_ListElem<sir_tmpvar>;


	/* member list */

template class SIR_List<sir_member>;
template class SIR_ListElem<sir_member>;


	/* usertype list */

template class SIR_List<sir_usertype>;
template class SIR_ListElem<sir_usertype>;


	/* symbol list */

template class SIR_List<sir_symbol>;
template class SIR_ListElem<sir_symbol>;


	/* symbol pointer list */

template class SIR_List<sir_symbol_ptr>;
template class SIR_ListElem<sir_symbol_ptr>;


        /* event list */

template class SIR_List<sir_event>;
template class SIR_ListElem<sir_event>;

/* EOF List.cc */
