// i_semaphore.sc: provides protected access to shared resources
// (only a specified number of threads can use the resources at a time)
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/12/02 RD	applied naming convention, integrated with distribution
// 01/23/02 RD	added method 'attempt', minor changes
// 01/23/02 RD	bug fix: allow to wake up multiple threads at the same time
// 01/22/02 RD	bug fix: only call 'notifyone' if any threads are waiting
// 01/22/02 RD	brush up, moved into separate file "semaphore.sc"
// 12/27/01 RD	initial version
//
//
// interface rules:
//
// - each thread must call acquire() before using a resource
//   and call release() when the resource is not used any more
// - calling release() without prior call to acquire() is illegal
// - calling acquire() multiple times in order to reserve multiple resources
//   at the same time is legal; however, a deadlock situation may occur
//   if an insufficient number of resources is available
// - release() may only be called as many times as acquire() has been called
// - calling acquire() may suspend the calling thread indefinitely
// - method attempt() tries to aquire a resource without any waiting
//   and returns immediately with or without success
// - attempt() returns false if the resource could not be acquired
// - attempt() returns true if the resource has successfully been acquired
// - a successful attempt() must be followed by a call to release()
// - an unsuccessful attempt() must not be followed by a call to release()
// - if a thread needs to obtain multiple resources at the
//   same time, a global partial order of obtaining the resources
//   should be used, otherwise deadlock situations may occur


interface i_semaphore
{
    void release(void);
    void acquire(void);
    bool attempt(void);
};


// EOF i_semaphore.sc
