// barrier_test.sc: test bench for c_barrier.sc
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/12/02 RD	applied naming convention, integrated with distribution
// 02/06/02 RD	initial version


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>


#ifndef THREADS
#define THREADS		3ul	// number of threads using the barrier
#endif				// (max. 5!)

import "c_barrier";


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((unsigned int)(drand48() * (double)Range));
}


behavior Thread(
    i_barrier Barrier,
    in int    ID)
{
    void Sync(void)
    {
	printf("Time%4s: Thread %d blocking on barrier.\n",
		time2str(now()), ID);
	Barrier.barrier();
	printf("Time%4s: Thread %d resuming.\n",
		time2str(now()), ID);
    }

    void Sleep(void)
    {
	int Duration;

	Duration = Rnd(10);
	printf("Time%4s: Thread %d going to sleep for %d time units.\n",
		time2str(now()), ID, Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int i;

	for(i=0; i<100; i++)
	{
	    Sync();
	    Sleep();
	}
    }
};


behavior Main			// test bench for barrier
{
    c_barrier Barrier(THREADS);
    Thread    t1(Barrier, 1),
              t2(Barrier, 2),
              t3(Barrier, 3),
              t4(Barrier, 4),
              t5(Barrier, 5);

    int main(void)
    {
	printf("Time%4s: barrier_test%d: Starting...\n",
		time2str(now()), (int)THREADS);
	printf("Time%4s: Running %d threads.\n",
		time2str(now()), (int)THREADS);
	par {	t1.main();
#if THREADS>1
		t2.main();
#endif
#if THREADS>2
		t3.main();
#endif
#if THREADS>3
		t4.main();
#endif
#if THREADS>4
		t5.main();
#endif
		}
	printf("Time%4s: barrier_test%d: Done.\n",
		time2str(now()), (int)THREADS);
	return 0;
    }
};


// EOF barrier_test.sc
