// notifyone4.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior A(in event e, inout int x)
{
	void main(void)
	{
	int	i;

	for(i=0; i<100; i++)
	   { wait e;
	     x++;
	    }
	}
};

behavior B(in event e, inout int y)
{
	void main(void)
	{
	int	i;

	for(i=0; i<100; i++)
	   { wait e;
	     y++;
	    }
	}
};

behavior C(out event e, in int x, in int y)
{
	void main(void)
	{
	int	i;

	for(i=0; i<10; i++)
	   { notifyone e;
	     waitfor(1);
	    }
	assert(x + y == 10);

	for(i=0; i<10; i++)
	   { notifyone e;
	     waitfor(1);
	    }
	assert(x + y == 20);

	for(i=0; i<10; i++)
	   { notifyone e;
	     waitfor(1);
	    }
	assert(x + y == 30);

	for(i=0; i<70; i++)
	   { notifyone e;
	     waitfor(1);
	    }
	assert(x + y == 100);

	for(i=0; i<100; i++)
	   { notifyone e;
	     waitfor(1);
	    }
	assert(x + y == 200);
	}
};

behavior Main
{
	event	e;
	int	x = 0;
	int	y = 0;
	A	a(e, x);
	B	b(e, y);
	C	c(e, x, y);

	int main(void)
	{
	puts("notifyone4: Starting...");

	par {	a.main();
		b.main();
		c.main();
		};
	assert(x + y == 200);
	assert(now() == 200);

	puts("notifyone4: Done.");
	return(0);
	}
};

// EOF
