// tanimoto1.sc
//
// orignal by Tadaaki Tanimoto
// 03/21/02 modified for SpecC 2.0 by Rainer Doemer
// - use 'signal's!
// - use 'bit[1]' instead of 'int'
// - no need for explicit OPEN (just leave port map empty)
// 03/22/02 parallized, fixed testbench, other fixes (RD)
// 12/12/02 finalized waiting on rising CLK
// 01/06/03 integrated into source tree as test case

#include <stdio.h>
#include <stdlib.h>
#include "../../inc/sim.sh"	// #include <sim.sh>


behavior FF  ( in signal bit[1]  CLK,	// NEW!
               in signal bit[1]  D,	// NEW!
               out signal bit[1] Q,	// NEW!
               out signal bit[1] QN ) {	// NEW!

      void main( void ) {
	while(true) {
           wait ( CLK rising );		// NEW!
           Q  = D ;
           QN = !D ;
	}
      }
} ;

behavior LSI ( in signal bit[1] CLK,	// NEW!
               in signal bit[1] D,	// NEW!
               out signal bit[1] O ) {	// NEW!
    signal bit[1] QN ;			// NEW!

    FF  B1( CLK, D,   , QN )  ;		// removed OPEN
    FF  B2( CLK, QN, O,    )  ;		// removed OPEN

      void main( void ) {
        par {
          B1.main() ;
          B2.main() ;
        }
      }
} ;

behavior Stimulator(
	inout signal bit[1] CLK,
	out signal bit[1] D)
{
      void main( void ) {
        int i ;
          D = 1;
          for ( i=0; i<8; i++ ) {
            if ( i==0 ) {
              CLK = 0b;
            } else {
              CLK = !CLK ;
            }
            if ( i==5 )  D = 0b;
            waitfor( 10 );
          }
	exit(0);
      }
};

behavior Monitor(
	in signal bit[1] CLK,
	in signal bit[1] D,
	in signal bit[1] O)
{
    void main(void)
    {
	char buf1[3], buf2[3], buf3[3];

	while(true)
	{
	    wait CLK, D, O;
	    printf("%s:\tCLK=%s\tD=%s\tO=%s\n",
			time2str(now()),
			ubit2str(2, &buf1[2], CLK),
			ubit2str(2, &buf2[2], D),
			ubit2str(2, &buf3[2], O));
	}
    }
};

behavior Main {

    signal bit[1]  CLK  ;		// NEW!
    signal bit[1]  D    ;		// NEW!
    signal bit[1]  O    ;		// NEW!

    Stimulator s1(CLK, D);
    LSI Top( CLK, D, O );
    Monitor m1(CLK, D, O);

      int main( void ) {
        par
	{
	    s1.main();
	    Top.main();
	    m1.main();
	}
	return(0);
      }
} ;

// EOF
