// BufBus.sc
//
// 03/12/03 RD	added assertions
// 03/11/03 RD	bug fixes and adjustments
// 03/05/03 RD	added constant and open mapping tests
// 03/04/03 RD	initial version

#include "../../inc/sim.sh"	// #include <sim.sh>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

behavior NibbleMonitor(
	in int Num,
	in buffered bit[4] Nibble)
{
    void main(void)
    {
	char	Buffer[5];
	bit[8]	CheckByte = 00000001b;
	bit[4]	CheckNibble;

	while(true)
	{
	    waitfor 1;
	    printf("NibbleMonitor %d @ %2s: Nibble is %s%s\n",
				Num, time2str(now()),
				Num == 1 ? "    " : "",
				ubit2str(2, &Buffer[5], Nibble));
	    CheckNibble = (Num == 1) ? CheckByte[3:0] : CheckByte[7:4];
	    assert(Nibble == CheckNibble);
	    CheckByte <<= 1;
	}
    }
};

behavior ByteInit(
	out buffered bit[8] Byte,
	inout event CLK)
{
    void main(void)
    {
	Byte = 00000001b;
	notify CLK;
	wait CLK;
    }
};

behavior ByteStimulus(
	inout buffered bit[8] Byte,
	out event CLK)
{
    void main(void)
    {
	int i;

	assert(Byte == 00000001b);
	for(i=0; i<9; i++)
	{
	    waitfor 1;
	    Byte <<= 1;
	    notify CLK;
	}
	assert(Byte == 00000000b);
	exit(0);	// terminate simulation now
    }
};

behavior Main
{
    event CLK;
    buffered[CLK] bit[8] b, b2;
    NibbleMonitor m1(1,b[3:0]);
    NibbleMonitor m2(2,b[7:4]);
    NibbleMonitor m3(3,1111b);	// constant mapping test
    ByteInit      i1(b, CLK);
    ByteStimulus  s1(b, CLK);
    ByteInit      i2( , CLK);	// open mapping test

    int main(void)
    {
	i1;
	par { m1; m2; s1; }
	return(10);	// never reached
    }
};

// EOF
