// c_critical_section.sc: provides protected access to a critical section
// (only one thread at a time can operate in the critical section)
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 10/04/02 RD	added rule about safety of exceptions
// 02/12/02 RD	applied naming convention, integrated with distribution
// 01/23/02 RD	initial version (based on mutex.sc)
//
//
// interface rules:
//
// - see file i_critical_section.sc
//
// channel rules:
//
// - one channel instance is required for each critical section
// - up to N threads may use the same channel instance, N=2**32-1
// - no guarantees are given for fairness of access
// - calling enter() may suspend the calling thread indefinitely
// - this channel is only safe with respect to exceptions, if any exceptions
//   are guaranteed to occur only for all communicating threads simultaneously;
//   the behavior is undefined, if any exceptions occur only for a subset
//   of the communicating threads
// - no restrictions exist for use of 'waitfor'
// - no restrictions exist for use of 'wait', 'notify', 'notifyone'


import "i_critical_section";


channel c_critical_section implements i_critical_section
{
    event         e;
    unsigned long n = 0;

    void enter(void)
    {
	if (n++)
	{
	    wait e;
	}
    }

    void leave(void)
    {
	if (--n)
	{
	    notifyone e;
	}
    }
};


// EOF c_critical_section.sc
