// handshake.sc: example for use of c_handshake
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/19/02 RD	initial version (based on handshake_test2.sc)


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>


import "c_handshake";	// import the standard channel


#define N	10	// number of computations


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((int)(drand48() * (double)Range));
}


behavior A(			// unit to compute x+42
    i_send    HandshakeOut,
    i_receive HandshakeIn,
    inout int Data)
{
    void Send(void)
    {
	printf("Time%4s: A sending data %d to B.\n",
		time2str(now()), Data);
	HandshakeOut.send();
    }

    void Receive(void)
    {
	printf("Time%4s: A waiting for data from B.\n",
		time2str(now()));
	HandshakeIn.receive();
	printf("Time%4s: A received data %d.\n",
		time2str(now()), Data);
    }

    void Compute(void)
    {
	printf("Time%4s: A computing %d + 42 = ",
		time2str(now()), Data);
	Data += 42;
	printf("%d.\n", Data);
    }

    void Sleep(void)
    {
	int Duration;

	Duration = Rnd(3);
	if (Duration)
	{
	    printf("Time%4s: A going to sleep for %d time units.\n",
			time2str(now()), Duration);
	    waitfor(Duration);
	}
    }

    void main(void)
    {
	Sleep();
	Compute();
	Sleep();
	Send();
	Sleep();
	Receive();
	Sleep();
	Compute();
	Sleep();
	Send();
	Sleep();
    }
};


behavior B(			// unit to compute x*3
    i_send    HandshakeOut,
    i_receive HandshakeIn,
    inout int Data)
{
    void Send(void)
    {
	printf("Time%4s: B sending data %d to A.\n",
		time2str(now()), Data);
	HandshakeOut.send();
    }

    void Receive(void)
    {
	printf("Time%4s: B waiting for data from A.\n",
		time2str(now()));
	HandshakeIn.receive();
	printf("Time%4s: B received data %d.\n",
		time2str(now()), Data);
    }

    void Compute(void)
    {
	printf("Time%4s: B computing %d * 3 = ",
		time2str(now()), Data);
	Data *= 3;
	printf("%d.\n", Data);
    }

    void Sleep(void)
    {
	int Duration;

	Duration = Rnd(3);
	if (Duration)
	{
	    printf("Time%4s: B going to sleep for %d time units.\n",
			time2str(now()), Duration);
	    waitfor(Duration);
	}
    }

    void main(void)
    {
	Sleep();
	Receive();
	Sleep();
	Compute();
	Sleep();
	Send();
	Sleep();
	Receive();
	Sleep();
	Compute();
	Sleep();
    }
};


behavior Main	// let's do a computation by using two units alternatively!
{
    c_handshake Handshake1,
		Handshake2;
    int         Data;
    A           a1(Handshake1, Handshake2, Data);
    B           b1(Handshake2, Handshake1, Data);

    int main(void)
    {
	int x;

	printf("Time%4s: handshake: Starting...\n",
		time2str(now()));
	printf("Time%4s: Computing f(x) = (((x+42)*3)+42)*3.\n",
		time2str(now()));
	for(x=0; x<N; x++)
	{
	    Data = x;
	    printf("Time%4s: New computation: x = %d.\n",
			time2str(now()), x);
	    par {   a1.main();
		    b1.main();
		}
	    printf("Time%4s: Checking f(%d) = %d : ",
			time2str(now()), x, Data);
	    if (Data == (((x+42)*3)+42)*3)
	    {
		printf("Correct!\n");
	    }
	    else
	    {
		printf("FALSE! Should be %d.\n",
			(((x+42)*3)+42)*3);
		exit(1);
	    }
	}
	printf("Time%4s: handshake: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF handshake.sc
