// queue_test1.sc: test bench for c_queue.sc
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/14/02 RD	applied naming convention, integrated with distribution
// 02/05/02 RD	eliminated useless sleeping, minor adjustments
// 02/04/02 RD	initial version, one sender and receiver thread


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>


#define QUEUE_SIZE	500	// length of the queue
#define N		100	// number of read and write transactions
				// (less than queue size!)

import "c_queue";


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((unsigned int)(drand48() * (double)Range));
}


behavior QueueUser(
    i_tranceiver Queue)
{
    void SendData(int s)
    {
	char Data[QUEUE_SIZE];
	int  i;

	assert(s >= 0);
	assert(s <= QUEUE_SIZE);
	printf("Time%4s: Queue user storing %d bytes.\n",
		time2str(now()), s);
	for(i=0; i<s; i++)
	{
	    Data[i] = (char) s;
	}
	Queue.send(Data, s);
    }

    void ReceiveData(int r)
    {
	char Data[QUEUE_SIZE];
	int  i;

	assert(r >= 0);
	assert(r <= QUEUE_SIZE);
	printf("Time%4s: Queue user loading %d bytes.\n",
		time2str(now()), r);
	Queue.receive(Data, r);
	for(i=0; i<r; i++)
	{
	    assert(Data[i] == (char) r);
	}
    }

    void main(void)
    {
	int i,
	    r = 0,
	    s = 0,
	    n = 0;

	for(i=0; i<2*N; i++)
	{
	    if (  (n > r)	// can we receive?
		&&(r < N))
	    {
		if (  (n + s < QUEUE_SIZE) // can we send?
		    &&(s < N))
		{
		    if (Rnd(2))	// send or receive
		    {
			ReceiveData(++r);
			n -= r;
		    }
		    else
		    {
			SendData(++s);
			n += s;
		    }
		}
		else	// must receive
		{
		    ReceiveData(++r);
		    n -= r;
		}
	    }
	    else	// must send
	    {
		SendData(++s);
		n += s;
	    }
	    printf("Time%4s: Queue contains %d bytes.\n",
			time2str(now()), n);
	}
	assert(r + s == i);
	assert(r == s);
	assert(n == 0);
    }
};


behavior Main			// test bench for queue
{
    c_queue   Queue(((const unsigned long)QUEUE_SIZE));
    QueueUser u1(Queue);

    int main(void)
    {
	printf("Time%4s: queue_test1: Starting...\n",
		time2str(now()));
	printf("Time%4s: Running 1 tranceiver.\n",
		time2str(now()));
	u1.main();
	printf("Time%4s: queue_test1: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF queue_test1.sc
