// i_token.sc: interface to token channel for use with 1 to N threads
// (a producer thread sends a number of tokens to a consumer thread)
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/12/02 RD	applied naming convention, integrated with distribution
// 02/06/02 RD	initial version (based on generalized handshake.sc)
//
//
// interface rules:
//
// - general interface to a token channel as known from Petri nets
// - each connected thread may act as a consumer or producer (or both)
// - a producer calls produce(n) to produce n tokens
// - a consumer calls consume(n) to consume n tokens
// - a call to produce() will produce the given number of tokens and
//   immediately return
// - a call to consume() will return immediately if the requested number
//   of tokens are already present, consuming those tokens
// - a call to consume() will block the caller if not enough tokens
//   are present, until a sufficient number of tokens has been produced
// - calling consume() may suspend the calling thread indefinitely


interface i_token
{
    void produce(unsigned long n);
    void consume(unsigned long n);
};


// EOF i_token.sc
