// c_barrier.sc: provides barrier synchronization between N threads
// (rendezvous between N threads)
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 10/04/02 RD	added rule about safety of exceptions
// 02/12/02 RD	applied naming convention, integrated with distribution
// 02/06/02 RD	initial version
//
//
// interface rules:
//
// - see file i_barrier.sc
//
// channel rules:
//
// - one channel instance is required for each barrier
// - at the time of barrier instantiation, the number N of participating
//   threads that use the barrier is fixed
// - valid values for N are in the range from 1 to 2**32-1 inclusively
// - exactly N threads must use the barrier; if less than N or more than N
//   threads use the barrier, the behavior is undefined
// - calling barrier() may suspend the calling thread indefinitely
// - this channel is only safe with respect to exceptions, if any exceptions
//   are guaranteed to occur only for all communicating threads simultaneously;
//   the behavior is undefined, if any exceptions occur only for a subset
//   of the communicating threads
// - no restrictions exist for use of 'waitfor'
// - no restrictions exist for use of 'wait', 'notify', 'notifyone'


import "i_barrier";


channel c_barrier(in unsigned long N) implements i_barrier
{
    event         e;
    unsigned long n = 0;

    void barrier(void)
    {
	if (++n >= N)
	{
	    notify e;
	    n = 0;
	}
	wait e;
    }
};


// EOF c_barrier.sc
