// tanimoto2.sc
//
// original Verilog code by Tadaaki Tanimoto
// 03/21/02, SpecC 2.0 code by Rainer Doemer
// 03/22/02, fixes by RD
// 12/12/02, finalized waiting on rising clock
// 01/06/03 integrated into source tree as test case

#include <stdio.h>
#include <stdlib.h>
#include "../../inc/sim.sh"	// #include <sim.sh>


behavior Stimulator(
    out signal bit[1] CLK,
    out signal bit[1] RST,
    out signal bit[1] D)
{
    void main(void)
    {
	CLK = 0b;
	D   = 1b;
	RST = 1b;
	waitfor(10);
	CLK = 1b;
	D   = 1b;
	RST = 0b;
	waitfor(10);
	CLK = 0b;
	D   = 1b;
	RST = 0b;
	waitfor(10);
	CLK = 1b;
	D   = 1b;
	RST = 0b;
	waitfor(10);
	CLK = 0b;
	D   = 1b;
	RST = 0b;
	waitfor(10);
	CLK = 1b;
	D   = 1b;
	RST = 1b;
	waitfor(10);
	CLK = 0b;
	waitfor(10);
	CLK = 1b;
	waitfor(10);
	CLK = 0b;
	waitfor(10);
	CLK = 1b;
	waitfor(10);
	CLK = 0b;
	waitfor(10);
	D   = 0b;
	CLK = 1b;
	waitfor(10);
	CLK = 0b;
	waitfor(10);
	CLK = 1b;
	waitfor(10);
	exit(0);
    }
};

behavior Monitor(
    in signal bit[1] CLK,
    in signal bit[1] RST,
    in signal bit[1] D,
    in signal bit[1] Q,
    in signal bit[1] O)
{
    void main(void)
    {
	char buf1[3], buf2[3], buf3[3], buf4[3], buf5[3];

	while(true)
	{
	    wait(CLK, RST, D, Q, O);
	    printf("%3s : CLK=%s RST=%s D=%s Q=%s O=%s\n",
			time2str(now()),
			ubit2str(2, &buf1[2], CLK),
			ubit2str(2, &buf2[2], RST),
			ubit2str(2, &buf3[2], D),
			ubit2str(2, &buf4[2], Q),
			ubit2str(2, &buf5[2], O));
	}
    }
};

behavior Mealy1(
    in signal bit[1] D,
    in signal bit[1] Q_tmp,
    out signal bit[1] Q)
{
    void main(void)
    {
	while(true)
	{
	    wait(D, Q_tmp);
	    Q = D ^ Q_tmp;
	}
    }
};

behavior Mealy2(
    in signal bit[1] CLK,
    in signal bit[1] RST,
    out signal bit[1] Q_tmp,
    in signal bit[1] Q)
{
    void main(void)
    {
	while(true)
	{
	    wait(CLK rising, RST falling);
	    if (!RST)
		Q_tmp = 0b;
	    else
		Q_tmp = Q;
	}
    }
};

behavior Mealy(
    in signal bit[1] CLK,
    in signal bit[1] RST,
    in signal bit[1] D,
    inout signal bit[1] Q)
{
    signal bit[1] Q_tmp;

    Mealy1 m1(D, Q_tmp, Q);
    Mealy2 m2(CLK, RST, Q_tmp, Q);

    void main(void)
    {
	par
	{
	    m1.main();
	    m2.main();
	}
    }
};

behavior LSI(
    in signal bit[1] CLK,
    in signal bit[1] RST,
    in signal bit[1] D,
    inout signal bit[1] Q,
    inout signal bit[1] O)
{
    Mealy b1(CLK, RST, D, Q);
    Mealy b2(CLK, RST, Q, O);

    void main(void)
    {
	par
	{
	    b1.main();
	    b2.main();
	}
    }
};

behavior Main
{
    signal bit[1] CLK;
    signal bit[1] RST;
    signal bit[1] D;
    signal bit[1] Q;
    signal bit[1] O;

    Stimulator s1(CLK, RST, D);
    LSI        l1(CLK, RST, D, Q, O);
    Monitor    m1(CLK, RST, D, Q, O);

    int main(void)
    {
	par
	{
	    s1.main();
	    l1.main();
	    m1.main();
	}
	return(0);
    }
};

// EOF
