/************************************************************************/
/* IntRep/Label.h: SpecC Internal Representation, Label Class		*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 10/20/97 */
/************************************************************************/

/* last update: 09/26/06 */

/* modifications: (most recent first)
 *
 * 09/26/06 PC  Adjustments for scrc 2.1
 * 06/03/05 RD	reorganized and renamed global type names
 * 01/17/05 RD	added SIR_INTERNAL sections
 * 06/15/04 PC  Adjustments for scrc 2.0
 * 04/07/03 RD	added SIR_Labels::CreateNewLabelName()
 * 02/28/03 RD	added SIR_Label::GetFunction() and SIR_Label::GetFctSymbol()
 * 02/04/03 RD	added support for labels at fsmd statements
 * 04/26/02 RD	added SIR_Label::CopyAnnotations()
 * 01/30/02 RD	allow indexed access to elements of composite annotations
 * 01/15/02 RD	added support for composite annotations
 * 05/31/01 RD	eliminated level 2 of SIR API
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 05/25/01 RD	introduced this header (last change was 04/12/99)
 */

#ifndef INTREP_LABEL_H
#define INTREP_LABEL_H


#include "Global.h"
#include "IntRep/Note.h"


/*** enumeration types **************************************************/


	/* none */


/*** type definitions ***************************************************/


typedef class SIR_Label			sir_label;
typedef SIR_List<sir_label>		sir_label_list;
typedef class SIR_Labels		sir_labels;

typedef class SIR_Statement		sir_statement;	/* cyclic link */
typedef class SIR_FsmdStmnt             sir_fsmdstmnt;  /* cyclic link */
typedef class SIR_Function              sir_function;   /* cyclic link */


/*** class declarations *************************************************/


	/*****************/
	/*** SIR_Label ***/
	/*****************/


class SIR_Label :		/* statement label */
	public SIR_ListElem<SIR_Label>	/* is a list element */
{
public:
gl_string	LabelName;	/* identifier of the label */
sir_statement	*Statement;	/* link to labeled stmnt. (NULL if unknown) */
sir_fsmdstmnt   *FsmdStmnt;     /* link to labeled fsmd stmnt. (or NULL) */
sir_notes	*Notes;		/* notes for this label (NULL if none) */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Label(			/* constructor #1 */
	const char	*LabelName,
	sir_statement	*Statement = NULL,
	sir_fsmdstmnt   *FsmdStmnt = NULL,      
	sir_notes	*Notes = NULL);

SIR_Label(			/* constructor #3 (duplicator) */
	sir_label	*Original);

~SIR_Label(void);		/* destructor */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);

ERROR DFS_ForAllNotes(		/* iterator over all notes (depth first) */
	sir_note_mptr	MemberFct,
	sir_note_marg	MemberFctArg);


ERROR Annotate(			/* attach a note to the label */
	sir_note	*NewNote);	/* (consumes NewNote) */
};


	/******************/
	/*** SIR_Labels ***/
	/******************/


class SIR_Labels :		/* list of all labels in a function */
	public SIR_List<SIR_Label>	/* is simply a list of labels */
{					/* with additional member(function)s */
public:

//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Labels(void);		/* constructor #1 (empty label list) */

SIR_Labels(			/* constructor #2 (duplicator) */
	sir_labels	*Original);

~SIR_Labels(void);		/* destructor */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);

ERROR DFS_ForAllNotes(		/* iterator over all notes (depth first) */
	sir_note_mptr	MemberFct,
	sir_note_marg	MemberFctArg);


sir_label *Define(			/* define a label */
	const char	*LabelName,	/* (might return NULL and SIR_Error) */
	sir_statement	*Statement);

sir_label *Define(                      /* define a label at a fsmd stmnt.(#2)*/
        const char      *LabelName,     /* (might return NULL and SIR_Error) */
        sir_fsmdstmnt   *FsmdStmnt);

ERROR CheckDefStatements(void);	/* check if all labels are defined */

void DeleteMarkedLabels(void);	/* deletes the marked labels from the list */

sir_label *FindOrInsert(	/* find or insert a label */
	const char	*LabelName);

sir_label *Insert(		/* insert a new label */
	sir_label	*Label);

sir_label *Find(		/* find a label */
	const char	*LabelName);	/* (returns NULL if not found) */
};


/*** exported functions *************************************************/


	/* none */


#endif /* INTREP_LABEL_H */

/* EOF IntRep/Label.h */
