// Wrapper.sc: interface port mapped onto a behavior... legal or illegal?
//
// or: Is a wrapper a behavior or a channel?

// notes:
// - the issue is whether a port of interface type can be mapped onto
//   an instance of a *behavior* that implements the interface
// - this was always allowed for channels, but silently forbidden
//   for behaviors (in the implementation)...
// - the LRM 1.0 states in 2.3.5(f) that both behavior and channel
//   instances are allowed for such a mapping
// - as of 08/16/02, there is no real reason why a behavior should
//   not be allowed in such a mapping; the only reasons found in the
//   code are some optimizing assumptions that such dependencies
//   do not exist
// - the implementation has been adjusted according to the decision
//   that behaviors should be handled the same way as channels!
//   RD, 08/16/02

interface I
{
void r(void);
void w(void);
};

interface M
{
void main(void);
};

behavior WB implements I
{
void r(void) { }
void w(void) { }
void main(void) { }
};

channel WC implements I
{
void r(void) { }
void w(void) { }
};

behavior B (I i)
{
void main(void)
   {
	i.r();
	i.w();
   }
};

channel C (I i) implements M
{
void main(void)
   {
	i.r();
	i.w();
   }
};

behavior Main
{
	WB wb;
	WC wc;
	B b1(wb);
	B b2(wc);
	C c1(wb);
	C c2(wc);

	int main(void)
	{
	wb.main();
	wb.r();
	wb.w();
	wc.r();
	wc.w();
	b1.main();
	b2.main();
	c1.main();
	c2.main();
	return 0;
	}
};
