// OnesCounter_M1_new.sc: OnesCounter, Accellera style 1 (SpecC 2.0)
//
// (last update: 02/12/03, RD)
//
// Model characteristics:
// - Accellera style:	1
// - SpecC language:	2.0
// - Machine type:	Mealy (input-based)
// - Reset type:	asynchronous
// - Output ports:	unbuffered


behavior OnesCounter(
	in  signal bool			CLK,	// system clock
	in  signal bool			RST,	// system reset
	in  signal unsigned bit[31:0]	Inport,
	in  signal unsigned bit[1]	Start,
	out signal unsigned bit[31:0]	Outport,
	out signal unsigned bit[1]	Done,
	out signal unsigned bit[1]	Busy)	// NEW
{
   void main(void)
   {
     fsmd(CLK; Inport, Start;		// sensitive to input ports (Mealy)
			RST)		// asynchronous reset
	{
	  buffered[CLK] unsigned bit[31:0]	Data;	// unmapped variables
	  buffered[CLK] unsigned bit[31:0]	Ocount;	// (buffered at CLK!)
	  buffered[CLK] unsigned bit[31:0]	Mask;
	  buffered[CLK] unsigned bit[31:0]	Temp;

	  if (RST)   {  Busy = 0;		// synchronous reset
			Outport = 0;
			Done = 0;
		       }

		      { Outport = 0;		// default assignments
			Done = 0;
			Busy = 1;
		       }
						// state actions
	  S0 :	      { if (Start)
			     Busy = 1;		// immediate feedback! (Mealy)
			else
			     Busy = 0;
			if (Start)
			     goto S1;
			else
			     goto S0;
		       }
	  S1 :	      {	Data = Inport;
			goto S2;
		       }
	  S2 :	      {	Ocount = 0;
			goto S3;
		       }
	  S3 :	      { Mask = 1;
			goto S4;
		       }
	  S4 :	      { Temp = Data & Mask;
			goto S5;
		       }
	  S5 :	      { Ocount += Temp;
			goto S6;
		       }
	  S6 :	      { Data = Data >> 1;
			if (Data == 0)
			     goto S7;
			else
			     goto S4;
		       }
	  S7 :	      { Outport = Ocount;
			Done = 1;
			Busy = 0;
			if (Start)
			     goto S7;
			else
			     goto S0;
		       }
	 }
    }
};


// test bench /////////////////////////////////////////////////////////////


#include <stdio.h>
#include <stdlib.h>
#include "../../inc/sim.sh"	// #include <sim.sh>


const sim_time ClockPeriod  = 10;
const unsigned int NumTests = 20;


unsigned int Rnd(unsigned int Range)	// random number in range [0...Range-1]
{
    return((unsigned int)(drand48() * (double)Range));
}


unsigned int Ones(unsigned int Value)
{
    unsigned int n;

    n = 0;
    while(Value)
    {
	n += Value & 1u;
	Value >>= 1;
    }
    return(n);
}


behavior ClockGen(
	out signal bool CLK)
{
    void main(void)
    {
	while(true)
	{
	    waitfor(ClockPeriod);
//	    printf("Time%6s: Clock tick!\n",
//			time2str(now()));
	    notify CLK;
	}
    }
};


behavior TestBench(
	in  signal bool			CLK,
	out signal bool			RST,
	out signal unsigned bit[31:0]	Inport,
	out signal unsigned bit[1]	Start,
	in  signal unsigned bit[31:0]	Outport,
	in  signal unsigned bit[1]	Done,
	in  signal unsigned bit[1]	Busy)
{
    void main(void)
    {
	unsigned int	Test,
			Value;

	printf("Time%6s: Starting...\n",
		time2str(now()));
	wait(CLK);

	printf("Time%6s: Resetting the unit...\n",
		time2str(now()));
	RST = 1;
	wait(CLK);

	Inport = 0;
	Start = 0;
	wait(CLK);

	RST = 0;
	wait(CLK);

	for(Test=1; Test<=NumTests; Test++)
	{
	    Value = Rnd(0xffff);
	    printf("Time%6s: Running test %u with value 0x%04x.\n",
			time2str(now()), Test, Value);
	    Inport = Value;
	    Start = 1;
	    waitfor 1;
	    if (! Busy)
	    {
		printf("Busy flag is not up!\n");
		exit(15);
	    }
	    while(!Done)
	    {
		wait(CLK);
	    }
	    if (Busy)
	    {
		printf("Busy flag is still up!\n");
		exit(15);
	    }

	    printf("Time%6s: Computed result is %u. ",
			time2str(now()), (unsigned int)Outport);
	    if (Outport == Ones(Value))
	    {
		printf("Correct!\n");
	    }
	    else
	    {
		printf("FALSE! Should be %u!\n", Ones(Value));
		exit(10);
	    }
	    Start = 0;
	    while(Done)
	    {
		wait(CLK);
	    }
	}
	printf("Time%6s: Done.\n",
		time2str(now()));
	exit(0); // stop the simulation
    }
};


behavior Main
{
    signal bool             CLK;
    signal bool             RST;
    signal unsigned bit[32] Data1,
                            Data2;
    signal unsigned bit[1]  Flag1,
                            Flag2,
			    BusyFlag;
    ClockGen         cg0(CLK);
    OnesCounter      oc0(CLK, RST, Data1, Flag1, Data2, Flag2, BusyFlag);
    TestBench        tb0(CLK, RST, Data1, Flag1, Data2, Flag2, BusyFlag);

    int main(void)
    {
	par
	{
	    cg0.main();
	    oc0.main();
	    tb0.main();
	}
	return(0);
    }
};


// EOF
