// try19.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior Try
{
	void main(void)
	{
	waitfor 100;
	}
};

behavior TrapA(inout int x)
{
	void main(void)
	{
	x++;
	waitfor 1;
	}
};

behavior TrapB(inout int y)
{
	void main(void)
	{
	y++;
	waitfor 2;
	}
};

behavior InterruptA(inout int x)
{
	void main(void)
	{
	x++;
	waitfor 3;
	}
};

behavior InterruptB(inout int y)
{
	void main(void)
	{
	y++;
	waitfor 4;
	}
};

behavior TryLo(inout int x, inout int y,
		in event e1, in event e2, in event e3, in event e4,
		in event l1, in event l2, in event l3, in event l4)
{
	Try		t;
	TrapA		ta(x);
	TrapB		tb(y);
	InterruptA	ia(x);
	InterruptB	ib(y);

	void main(void)
	{
	try {	t.main();
		}
		trap e1, l1
		    {	ta.main();
			}
		trap e2, l2
		    {	tb.main();
			}
		interrupt e3, l3
		    {	ia.main();
			}
		interrupt e4, l4
		    {	ib.main();
			};
	}
};

behavior TryHi(inout int xhi, inout int yhi, inout int xlo, inout int ylo,
		in event e1, in event e2, in event e3, in event e4,
		in event l1, in event l2, in event l3, in event l4)
{
	TryLo		tlo(xlo, ylo, e1, e2, e3, e4, l1, l2, l3, l4);
	TrapA		ta(xhi);
	TrapB		tb(yhi);
	InterruptA	ia(xhi);
	InterruptB	ib(yhi);

	void main(void)
	{
	try {	tlo.main();
		}
		trap e1
		    {	ta.main();
			}
		trap e2
		    {	tb.main();
			}
		interrupt e3
		    {	ia.main();
			}
		interrupt e4
		    {	ib.main();
			};
	}
};

behavior Trigger1(
		in int xhi, in int yhi, in int xlo, in int ylo,
		out event e1, out event e2, out event e3, out event e4,
		out event l1, out event l2, out event l3, out event l4)
{
	void main(void)
	{
	notify e3;
	waitfor 5;
	assert(xhi == 1);
	assert(yhi == 0);
	assert(xlo == 0);
	assert(ylo == 0);
	assert(now() == 5);

	notify l3;
	waitfor 5;
	assert(xhi == 1);
	assert(yhi == 0);
	assert(xlo == 1);
	assert(ylo == 0);
	assert(now() == 10);

	notify e3, l3;
	waitfor 5;
	assert(xhi == 2);
	assert(yhi == 0);
	assert(xlo == 1);
	assert(ylo == 0);
	assert(now() == 15);

	notify l4, e4;
	waitfor 5;
	assert(xhi == 2);
	assert(yhi == 1);
	assert(xlo == 1);
	assert(ylo == 0);
	assert(now() == 20);

	notify l3;
	waitfor 1;
	notify e3;
	waitfor 4;
	assert(xhi == 3);
	assert(yhi == 1);
	assert(xlo == 2);
	assert(ylo == 0);
	assert(now() == 25);

	notify e3;
	waitfor 1;
	notify l3;
	waitfor 4;
	assert(xhi == 4);
	assert(yhi == 1);
	assert(xlo == 2);
	assert(ylo == 0);
	assert(now() == 30);

	notify l4;
	waitfor 1;
	notify e2;
	waitfor 4;
	assert(xhi == 4);
	assert(yhi == 2);
	assert(xlo == 2);
	assert(ylo == 1);
	assert(now() == 35);

	notify e1, e2, e3, e4, l1, l2, l3, l4;
	waitfor 5;
	assert(xhi == 4);
	assert(yhi == 2);
	assert(xlo == 2);
	assert(ylo == 1);
	assert(now() == 40);
	}
};

behavior Trigger2(
		in int xhi, in int yhi, in int xlo, in int ylo,
		out event e1, out event e2, out event e3, out event e4,
		out event l1, out event l2, out event l3, out event l4)
{
	void main(void)
	{
	notify e1, e2, e3, e4, l1, l2, l3, l4;
	waitfor 5;
	assert(xhi == 5);
	assert(yhi == 2);
	assert(xlo == 2);
	assert(ylo == 1);
	assert(now() == 45);

	notify e1, e2, e3, e4, l1, l2, l3, l4;
	waitfor 5;
	assert(xhi == 5);
	assert(yhi == 2);
	assert(xlo == 2);
	assert(ylo == 1);
	assert(now() == 50);
	}
};

behavior Trigger3(
		in int xhi, in int yhi, in int xlo, in int ylo,
		out event e1, out event e2, out event e3, out event e4,
		out event l1, out event l2, out event l3, out event l4)
{
	void main(void)
	{
	notify l1, l2, l3, l4;
	waitfor 5;
	assert(xhi == 5);
	assert(yhi == 2);
	assert(xlo == 3);
	assert(ylo == 1);
	assert(now() == 55);

	notify e1, e2, e3, e4, l1, l2, l3, l4;
	waitfor 5;
	assert(xhi == 5);
	assert(yhi == 2);
	assert(xlo == 3);
	assert(ylo == 1);
	assert(now() == 60);
	}
};

behavior Main
{
	event		e1, e2, e3, e4, l1, l2, l3, l4;
	int		xhi = 0;
	int		yhi = 0;
	int		xlo = 0;
	int		ylo = 0;

	TryHi		thi(xhi, yhi, xlo, ylo, e1, e2, e3, e4, l1, l2, l3, l4);
	Trigger1	t1(xhi, yhi, xlo, ylo, e1, e2, e3, e4, l1, l2, l3, l4);
	Trigger2	t2(xhi, yhi, xlo, ylo, e1, e2, e3, e4, l1, l2, l3, l4);
	Trigger3	t3(xhi, yhi, xlo, ylo, e1, e2, e3, e4, l1, l2, l3, l4);

	int main(void)
	{
	puts("try19: Starting...");

	par {	thi.main();
		t1.main();
		}
	assert(xhi == 4);
	assert(yhi == 2);
	assert(xlo == 2);
	assert(ylo == 1);
	assert(now() == 40);

	par {	thi.main();
		t2.main();
		}
	assert(xhi == 5);
	assert(yhi == 2);
	assert(xlo == 2);
	assert(ylo == 1);
	assert(now() == 50);

	par {	thi.main();
		t3.main();
		}
	assert(xhi == 5);
	assert(yhi == 2);
	assert(xlo == 3);
	assert(ylo == 1);
	assert(now() == 60);

	puts("try19: Done.");
	return(0);
	}
};

// EOF
