// alu_fct.sc
// (last update: 02/22/02, RD)


bit[31:0] alu(bit[31:0] a, bit[31:0] b, bit[3:0] ctrl)
{
    switch(ctrl)
    {
	case 0000b: return(a + b);
	case 0001b: return(a - b);
	case 0010b: return(a < b);
	case 0011b: return(a <= b);
	case 0100b: return(a > b);
	case 0101b: return(a >= b);
	case 0110b: return(a != b);
	case 0111b: return(a == b);
	case 1000b: return(a & b);
	case 1001b: return(a | b);
	case 1010b: return(a ^ b);
	case 1011b: return(!a);
	case 1100b: return(!b);
	case 1101b: return(~a);
	case 1110b: return(~b);
	default:    return(a);
    }
}

// eof
