/************************************************************************/
/* IntRep/FsmdStmnt.h: SpecC Internal Representation, FsmdStmnt Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 01/30/03 */
/************************************************************************/

/* last update: 09/26/06 */

/* modifications: (most recent first)
 *
 * 09/26/06 PC  Adjustments for scrc 2.1
 * 06/03/05 RD	reorganized and renamed global type names
 * 01/14/05 RD	replaced inclusion of IntRep/DelydAssgn.h with IntRep/Expression.h
 * 06/15/04 PC  Adjustments for scrc 2.0
 * 11/05/03 RD	added method SIR_FsmdStmnt::GetScope()
 * 10/31/03 RD	reworked state reachability analysis (i.e. ReachableStates())
 * 10/30/03 RD	added method GetSwitchStmnt() for control-flow analysis
 * 10/29/03 RD	added member ParentStmnt to SIR_FsmdStmnt
 * 10/23/03 RD	completed support for PIPED and AFTER in fsmd statements
 * 10/21/03 RD	added TmpVar member and comment about possible NULL value
 *		returned by GetStatement()
 * 10/03/03 RD	more support for PIPED and AFTER in fsmd statements
 * 09/12/03 RD	added support for PIPED and AFTER in fsmd statements
 * 03/03/03 RD	removed struct SIR_FsmdStmntRplArg (doubles SIR_StmntRplArg)
 * 02/21/03 RD	fixed the dependency analysis among symbols with respect to
 *		the now supported local variables in functions
 * 02/13/03 RD	adjustment for C++ code generation
 * 02/06/03 RD	refined/extended/added methods
 * 02/04/03 RD	initial version (based on Statement.h)
 */


#ifndef INTREP_FSMDSTMNT_H
#define INTREP_FSMDSTMNT_H


#include "Global.h"
#include "IntRep/Label.h"
#include "IntRep/DelydAssgn.h"


/*** enumeration types **************************************************/


enum SIR_FsmdStmntType		/* fsmd statement types */
{				/* (see class SIR_FsmdStmnt) */

SIR_FSMDSTMNT_COMPOUND,		// Create() #1, no expression
SIR_FSMDSTMNT_EXPRESSION,	// Create() #1, 1 expression
SIR_FSMDSTMNT_AFTER_EXPR,	// Create() #1, 1 expression
SIR_FSMDSTMNT_PIPED_EXPR,	// Create() #1, 1 expression
SIR_FSMDSTMNT_IF,		// Create() #1, 1 expression
SIR_FSMDSTMNT_IF_ELSE,		// Create() #1, 1 expression
SIR_FSMDSTMNT_SWITCH,		// Create() #1, 1 expression
SIR_FSMDSTMNT_CASE,		// Create() #2
SIR_FSMDSTMNT_DEFAULT,		// Create() #1, no expression
SIR_FSMDSTMNT_GOTO,		// Create() #3
SIR_FSMDSTMNT_BREAK		// Create() #1, no expression
};

enum SIR_Dependency		/* type of dependency among symbols */
{
SIR_DEP_NONE		= 0,	/* independent */
SIR_DEP_INSTANTIATION	= 1,	/* instantiated by symbol */
SIR_DEP_IMPLEMENTATION	= 2,	/* implemented by symbol */
SIR_DEP_CONNECTION	= 3,	/* connected with (mapped to) symbol */
SIR_DEP_STATEMENT	= 4,	/* used in statement */
SIR_DEP_EXPRESSION	= 5,	/* used in expression, statement */
SIR_DEP_CLOCK		= 6,	/* clock specifier for 'buffered' symbol */
SIR_DEP_RESET		= 7	/* reset specifier for 'buffered' symbol */
};


/*** type definitions ***************************************************/


typedef enum SIR_FsmdStmntType		SIR_FSMDSTMNT;
typedef enum SIR_Dependency		SIR_DEPENDENCY;

typedef class SIR_FsmdStmnt		sir_fsmdstmnt;
typedef SIR_List<sir_fsmdstmnt>		sir_fsmdstmnt_list;
typedef class SIR_FsmdStmnts		sir_fsmdstmnts;
typedef ERROR 			(*sir_fsmdstmnt_fct)(sir_fsmdstmnt*, void*);
typedef struct SIR_FsmdStmntRep		sir_fsmdstmnt_rep;
typedef struct SIR_FsmdStmntsRep	sir_fsmdstmnts_rep;
typedef void *				sir_fsmdstmnt_marg;
typedef ERROR (SIR_FsmdStmnt::*sir_fsmdstmnt_mptr)(void*);
typedef struct SIR_FsmdStmntUarg
	{
	sir_fsmdstmnt_fct	CallerFct;
	void			*CallerArg;
	}				sir_fsmdstmnt_uarg;

typedef class SIR_Symbol		sir_symbol;	/* cyclic link */
typedef class SIR_Symbols		sir_symbols;	/* cyclic link */
typedef void *				sir_symbol_marg;/* cyclic link */
typedef ERROR (SIR_Symbol::*sir_symbol_mptr)(void*);	/* cyclic link */

typedef class SIR_UserType		sir_usertype;	/* cyclic link */
typedef void *				sir_usertp_marg;/* cyclic link */
typedef ERROR (SIR_UserType::*sir_usertp_mptr)(void*);	/* cyclic link */

typedef class SIR_FsmdState		sir_fsmdstate;	/* cyclic link */
typedef class SIR_StatePtrs		sir_state_ptrs;	/* cyclic link */
typedef class SIR_Function		sir_function;	/* cyclic link */
typedef class SIR_Variables		sir_variables;	/* cyclic link */


/*** class declarations *************************************************/


	/*********************/
	/*** SIR_FsmdStmnt ***/
	/*********************/


class SIR_FsmdStmnt :			/* fsmd statement */
	public SIR_Node,			/* is a node */
	public SIR_ListElem<SIR_FsmdStmnt>	/* and a list element */
{
public:
SIR_FSMDSTMNT	StmntType;	/* fsmd statement type */
sir_symbol	*Function;	/* link back to the function this is part of */
sir_fsmdstmnt	*ParentStmnt;	/* link back to parent (NULL for root) */
sir_expression	*Expression;	/* expression (or NULL) */
int		Cycles;		/* 'after'/'piped' number of cycles (or 0) */
sir_constant	*Constant;	/* constant (or NULL) */
sir_fsmdstmnt	*FsmdStmnt1;	/* first sub-statement (NULL if none) */
sir_fsmdstmnt	*FsmdStmnt2;	/* second sub-statement (NULL if none) */
sir_label	*Label;		/* pointer to label (NULL if unlabeled) */
sir_symbols	*Scope;		/* local scope (or NULL) */
sir_fsmdstmnts	*FsmdStmnts;	/* list of statements (or NULL) */
sir_fsmdstate	*NextState;	/* link to next state (for goto, else NULL) */
sir_variables	*Variables;	/* API level 2: local variables (or NULL) */

sir_tmpvar	*TmpVar;	/* temp. variable ('piped'/'after') */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_FsmdStmnt(				/* constructor #1 */
	SIR_FSMDSTMNT	StmntType,	/* (for general statements) */
	sir_symbol	*Function,
	sir_expression	*Expression = NULL,
	sir_fsmdstmnt	*FsmdStmnt1 = NULL,
	sir_fsmdstmnt	*FsmdStmnt2 = NULL,
	sir_label	*Label = NULL,
	unsigned int	Line = 0,
	sir_fileinfo	*FileInfo = NULL,
	int		Cycles = 0);

SIR_FsmdStmnt(				/* constructor #2 */
	SIR_FSMDSTMNT	StmntType,	/* (for compound statements) */
	sir_symbol	*Function,
	sir_symbols	*Scope,
	sir_fsmdstmnts	*FsmdStmnts,
	sir_label	*Label = NULL,
	unsigned int	Line = 0,
	sir_fileinfo	*FileInfo = NULL);

SIR_FsmdStmnt(				/* constructor #3 */
	SIR_FSMDSTMNT	StmntType,	/* (for case statements) */
	sir_symbol	*Function,
	sir_constant	*Constant,
	sir_fsmdstmnt	*FsmdStmnt1 = NULL,
	sir_label	*Label = NULL,
	unsigned int	Line = 0,
	sir_fileinfo	*FileInfo = NULL);

SIR_FsmdStmnt(				/* constructor #4 */
	SIR_FSMDSTMNT	StmntType,	/* (for goto statements) */
	sir_symbol	*Function,
	sir_fsmdstate	*NextState,
	sir_label	*Label = NULL,
	unsigned int	Line = 0,
	sir_fileinfo	*FileInfo = NULL);

SIR_FsmdStmnt(				/* constructor #5 (from ext. rep.) */
	sir_fsmdstmnt_rep *StmntRep);

SIR_FsmdStmnt(				/* constructor #6 (duplicator) */
	sir_fsmdstmnt	*Original,
	sir_fsmdstmnt	*ParentStmnt = NULL);

~SIR_FsmdStmnt(void);			/* destructor */


static sir_fsmdstmnt *New(		/* luxury constructor (#1) */
	sir_symbol	*Function,	/* (returns NULL if SIR_Error) */
	sir_fsmdstmnt	*ParentStmnt,
	sir_symbols	*ParentScope,
	SIR_FSMDSTMNT	StmntType,
	sir_expression	*NewExpr = NULL,
	sir_label	*Label = NULL,
	int		Cycles = 0);

static sir_fsmdstmnt *New(		/* luxury constructor (#2) */
	sir_symbol	*Function,	/* (returns NULL if SIR_Error) */
	sir_fsmdstmnt	*ParentStmnt,
	sir_symbols	*ParentScope,
	sir_constant	*NewConstant,
	sir_label	*Label = NULL);

static sir_fsmdstmnt *New(		/* luxury constructor (#3) */
	sir_symbol	*Function,	/* (returns NULL if SIR_Error) */
	sir_fsmdstmnt	*ParentStmnt,
	sir_fsmdstate	*NextState,
	sir_label	*Label = NULL);


bool IsIndirectDependant(		/* checks if stmnt. depends on symbol */
	sir_symbol	*ThatSymbol,	/* (indirectly, through expression) */
	SIR_DEPENDENCY	*Reason = NULL,
	sir_expression	**DepExpr = NULL);


sir_fsmdstmnts *GetList(void);	/* determines the list of this statement */
				/* (returns NULL if not in a list) */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);

ERROR DFS_ForAllSymbols(	/* iterator over all symbols (depth first) */
	sir_symbol_mptr	MemberFct,
	sir_symbol_marg	MemberFctArg);

ERROR DFS_ForAllUserTypes(	/* iterator over all usertypes (depth first) */
	sir_usertp_mptr	MemberFct,
	sir_usertp_marg	MemberFctArg);

ERROR DFS_ForAllNotes(		/* iterator over all notes (depth first) */
	sir_note_mptr	MemberFct,
	sir_note_marg	MemberFctArg);

ERROR DFS_ForAllFsmdStmnts(	/* iterator over all fsmd statements (dfs) */
	sir_fsmdstmnt_mptr	MemberFct,
	sir_fsmdstmnt_marg	MemberFctArg);

ERROR DFS_ForAllExpressions(	/* iterator over all expressions (dfs) */
	sir_expr_mptr	MemberFct,
	sir_expr_marg	MemberFctArg);

bool DFS_FindDirectDependant(	/* searches for direct dependants (dfs) */
	sir_symbol	**SkipSymbol,
	sir_symbol	*ThatSymbol,
	sir_symbol	**DepSymbol,
	SIR_DEPENDENCY	*Reason);

bool DFS_FindIndirectDependant(	/* searches for indirect dependants (dfs) */
	sir_symbol	*ThatSymbol,
	sir_fsmdstmnt	**DepStmnt,
	sir_expression	**DepExpr,
	SIR_DEPENDENCY	*Reason);


ERROR CallCaller(		/* iterator calls the users function */
	sir_fsmdstmnt_marg	CallerArgs);

ERROR ForEachDef(		/* iterator for iterator over all defs. */
	sir_fsmdstmnt_marg	CallerArgs);

ERROR ForEachVar(		/* iterator for iterator over all vars. */
	sir_fsmdstmnt_marg	CallerArgs);

ERROR MarkYourLabel(		/* iterator for color marking */
	sir_fsmdstmnt_marg	ColorArg);

ERROR CheckLabeledStmnt(	/* iterator for label checking */
	sir_fsmdstmnt_marg	/* Unused */);

ERROR CheckControlFlow(		/* iterator for control flow checking */
	sir_fsmdstmnt_marg	/* Unused */);

ERROR ReplaceDeps(		/* iterator for replacing dependencies */
	sir_fsmdstmnt_marg	ReplaceArgs);

ERROR TargetsState(		/* iterator for finding transitions */
	sir_fsmdstmnt_marg	TargetArg);

void SetAlias(			/* sets all type, usertype, symbol alias' */
	sir_fsmdstmnt	*Alias);/* (iterates over symbols and usertypes) */

void UnAlias(			/* unalias all type, usertype, symbol links */
	sir_symbols	*GlobalSymbols);


ERROR WriteSC(			/* (re-) generates SpecC source code */
	gl_io		*IO,
	bool		WriteNotes,
	bool		CplusplusMode = false,
	bool		PutNewLine = true,
	bool		IsFsmdState = false,
	bool		BreakExitsFsmd = true);


sir_fsmdstmnt *WrapInCompound(	/* wrap this stmnt. in a new compound stmnt.*/
	sir_symbols	*ParentScope);	/* (caller must fix father pointers) */

void CompoundSubBlocks(		/* compound all statement blocks below */
	void);			/* (insert missing compound statements) */

ERROR CreateDelayedAssignments(	/* create 'after'/'piped' temps. */
	sir_tmpvars	*TmpVars,
	sir_state_ptrs	*NextStates,
	const char	*StateName,
	sir_expression	*Condition = NULL);

void DeleteDelayedAssignments(	/* delete 'after'/'piped' temps. */
	void);


sir_state_ptrs *ReachableStates(	/* collect all reachable next states */
	sir_state_ptrs	*StateList);	/* (consumes StateList, returns new) */

bool BreakExitsFsmd(void);      /* check if 'break' exits 'fsmd' or 'switch' */

sir_statement *GetStatement(    /* obtain a pointer to the 'fsmd' statement */
        void);

sir_fsmdstmnt *GetSwitchStmnt(  /* obtain control-flow parent statement */
        void);                  /* (for BREAK, CASE, DEFAULT) */
};


        /**********************/
        /*** SIR_FsmdStmnts ***/
        /**********************/


class SIR_FsmdStmnts :          /* sequence of fsmd statements */
        public SIR_List<SIR_FsmdStmnt>  /* is simply a list of fsmd stmnts. */
{                                       /* with additional member(function)s */
public:
sir_symbols     *CmpndScope;    /* link to compound statement scope */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_FsmdStmnts(			/* constructor #1 */
	sir_symbols	*CmpndScope = NULL,
	sir_fsmdstmnt	*FirstEntry = NULL);

SIR_FsmdStmnts(			/* constructor #3 (duplicator) */
	sir_fsmdstmnts	*Original,
	sir_fsmdstmnt	*ParentStmnt = NULL);

~SIR_FsmdStmnts(void);		/* destructor */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);

ERROR DFS_ForAllSymbols(	/* iterator over all symbols (depth first) */
	sir_symbol_mptr	MemberFct,
	sir_symbol_marg	MemberFctArg);

ERROR DFS_ForAllUserTypes(	/* iterator over all usertypes (depth first) */
	sir_usertp_mptr	MemberFct,
	sir_usertp_marg	MemberFctArg);

ERROR DFS_ForAllNotes(		/* iterator over all notes (depth first) */
	sir_note_mptr	MemberFct,
	sir_note_marg	MemberFctArg);

ERROR DFS_ForAllFsmdStmnts(	/* iterator over all fsmd statements (dfs) */
	sir_fsmdstmnt_mptr	MemberFct,
	sir_fsmdstmnt_marg	MemberFctArg);

ERROR DFS_ForAllExpressions(	/* iterator over all expressions (dfs) */
	sir_expr_mptr	MemberFct,
	sir_expr_marg	MemberFctArg);

bool DFS_FindDirectDependant(	/* searches for direct dependants (dfs) */
	sir_symbol	**SkipSymbol,
	sir_symbol	*ThatSymbol,
	sir_symbol	**DepSymbol,
	SIR_DEPENDENCY	*Reason);

bool DFS_FindIndirectDependant(	/* searches for indirect dependants (dfs) */
	sir_symbol	*ThatSymbol,
	sir_fsmdstmnt	**DepStmnt,
	sir_expression	**DepExpr,
	SIR_DEPENDENCY	*Reason);


void SetAlias(			/* sets all type, usertype, symbol alias' */
	sir_fsmdstmnts	*Alias);/* (iterates over symbols and usertypes) */

void UnAlias(			/* unalias all type, usertype, symbol links */
	sir_symbols	*GlobalSymbols);


};


/*** exported functions *************************************************/


	/* none */


#endif /* INTREP_FSMDSTMNT_H */

/* EOF IntRep/FsmdStmnt.h */
