// HeaderFile.sc:
// test case for importing a file that includes an already included header file
// (latest update: RD, 04/08/02)

#ifndef HEADER_FILE
#define HEADER_FILE

#define SOME_DEFINITION	"something"
#define SOME_MACRO	MAGIC(x,y) some_function(x,y,2)

struct SomeStructDecl;
union SomeUnionDecl;
enum SomeEnumDecl;

// when included and then imported,
// these used to result in error #2022!
// (SIR_ERROR_REDEFINITION_OF_USERTYPE_3)
struct SomeStructDef { int a, b, c; };
union SomeUnionDef { int i; float f; };
enum SomeEnumDef { e1, e2, e3 };

typedef int SomeTypeDef;
typedef struct { int a, b; } SomeStructTypeDef1;
typedef struct SomeStruct { int a, b; } SomeStructTypeDef2;

extern int SomeGlobalVarDecl;

// special case: types of x and y are different!
extern struct { int a, b; } x;
extern struct { int a, b; } y;

extern void SomeGlobalFunctionDecl(int, int);
extern void SomeOtherGlobalFunctionDecl(const SomeStructTypeDef1, SomeTypeDef);

// BUG!!! (discovered while playing with this stuff, 02/15/02, RD)
extern void bug(const struct SomeStructDecl *);

// BUG: forgotten case (fixed 02/20/02, RD)
struct Bigint
{
  struct Bigint *next;
  int k, maxwds, sign, wds;
  unsigned long x[1];
};

// BUG: forgotten case (found in Linux headers; fixed 04/08/02, RD)
enum /* anonymous */ { anon_enum0, anon_enum1, anon_enum2 };

#endif /* HEADER_FILE */

// EOF
