// Buffered2.sc: (updated 01/06/03, initial version 07/17/02, RD)

#include <stdio.h>
#include <assert.h>

behavior Buffer(
	in    buffered int BufferIn,
	out   buffered int BufferOut,
	inout buffered int BufferIO)
{
    void main(void)
    {
	event			e1,
				e2;
	buffered[e1] int	b1 = 0,
				b2 = 1;
	buffered[e1,e2] int	b3;
	buffered[e2] int	b4[2] = { 0, 1ull };
	buffered[e2] int	b5[2] = { 5, 5 };
	buffered[e2] int	b6[2][2] = {{1,2}, {3,4}};
	int			i1,
				i2;

	assert(b1 == 0);
	assert(b2 == 1);
	b1 = 1; b2 = 2;
	assert(b1 == 0);
	assert(b2 == 1);
	notify e1; wait e1;
	b1 = b2; b2 = b1;
	assert(b1 == 1);
	assert(b2 == 2);
	notify e1; wait e1;
	b1 = 42; b2 = 42;
	assert(b1 == 2);
	assert(b2 == 1);
	notify e1; wait e1;
	assert(b1 == 42);
	assert(b2 == 42);
	b1 = b2 - 17;
	b2 -= 25;
	assert(b1 == 42);
	assert(b2 == 42);
	notify e1; wait e1;
	assert(b1 == 25);
	assert(b2 == 17);

	assert(b4[0] == 0);
	assert(b4[1] == 1);
	b4[0] = 1; b4[1] = 2;
	assert(b4[0] == 0);
	assert(b4[1] == 1);
	notify e2; wait e2;
	b4[0] = b4[1]; b4[1] = b4[0];
	assert(b4[0] == 1);
	assert(b4[1] == 2);
	notify e2; wait e2;
	b4[0] = 42; b4[1] = 42;
	assert(b4[0] == 2);
	assert(b4[1] == 1);
	notify e2; wait e2;
	assert(b4[0] == 42);
	assert(b4[1] == 42);
	b4[0] = b4[1] - 17;
	b4[1] -= 25;
	assert(b4[0] == 42);
	assert(b4[1] == 42);
	notify e2; wait e2;
	assert(b4[0] == 25);
	assert(b4[1] == 17);

	assert(b4[0] == 25); assert(b4[1] == 17);
	assert(b5[0] ==  5); assert(b5[1] ==  5);
	b5 = b4;
	assert(b4[0] == 25); assert(b4[1] == 17);
	assert(b5[0] ==  5); assert(b5[1] ==  5);
	notify e2; wait e2;
	assert(b4[0] == 25); assert(b4[1] == 17);
	assert(b5[0] == 25); assert(b5[1] == 17);
	b5[1] = b4[0];
	b5[0] = b4[1];
	assert(b4[0] == 25); assert(b4[1] == 17);
	assert(b5[0] == 25); assert(b5[1] == 17);
	notify e2; wait e2;
	assert(b4[0] == 25); assert(b4[1] == 17);
	assert(b5[0] == 17); assert(b5[1] == 25);

	assert(b6[0][0] ==  1); assert(b6[0][1] ==  2);
	assert(b6[1][0] ==  3); assert(b6[1][1] ==  4);
	b6[0][0] = -1; b6[1][1] = -2;
	assert(b6[0][0] ==  1); assert(b6[0][1] ==  2);
	assert(b6[1][0] ==  3); assert(b6[1][1] ==  4);
	notify e2; wait e2;
	assert(b6[0][0] == -1); assert(b6[0][1] ==  2);
	assert(b6[1][0] ==  3); assert(b6[1][1] == -2);
	b6[1] = b5;
	assert(b6[0][0] == -1); assert(b6[0][1] ==  2);
	assert(b6[1][0] ==  3); assert(b6[1][1] == -2);
	notify e2; wait e2;
	assert(b6[0][0] == -1); assert(b6[0][1] ==  2);
	assert(b6[1][0] == 17); assert(b6[1][1] == 25);
	b6[0][0]++; b6[0][1] -= 2;
	b6[1][0] = b6[1][1]; b6[1][1] = b6[1][0];
	assert(b6[0][0] == -1); assert(b6[0][1] ==  2);
	assert(b6[1][0] == 17); assert(b6[1][1] == 25);
	notify e2; wait e2;
	assert(b6[0][0] ==  0); assert(b6[0][1] ==  0);
	assert(b6[1][0] == 25); assert(b6[1][1] == 17);

	b4[0] = b2; b2 = b4[0];
	assert(b4[0] == 25); assert(b4[1] == 17); assert(b2 == 17);
	notify e1, e2; wait e1, e2;
	assert(b4[0] == 17); assert(b4[1] == 17); assert(b2 == 25);
	b6[0] = b4; b4 = b6[0];
	assert(b6[0][0] ==  0); assert(b6[0][1] ==  0);
	assert(b4[0] == 17); assert(b4[1] == 17);
	notify e1, e2; wait e1, e2;
	assert(b6[0][0] == 17); assert(b6[0][1] == 17);
	assert(b4[0] ==  0); assert(b4[1] ==  0);

	{
	    signal int s1 = 1;
	    signal int s2[2] = { 2, 3 };
	    signal int s3[2][2] = {{4,5}, {6,7}};

	    b1 = s1;
	    b2 = s2[0];
	    b4 = s2;
	    b5 = s3[0];
	    assert(b1 == 25);
	    assert(b2 == 25);
	    assert(b4[0] ==  0); assert(b4[1] ==  0);
	    assert(b5[0] == 17); assert(b5[1] == 25);
	    notify e1, e2; wait e1, e2;
	    assert(b1 == 1);
	    assert(b2 == 2);
	    assert(b4[0] == 2); assert(b4[1] == 3);
	    assert(b5[0] == 4); assert(b5[1] == 5);

	    b4[0] = s1;
	    b5[0] = s2[0];
	    b6[0] = s2;
	    b6[1] = s3[0];
	    assert(b4[0] == 2); assert(b4[1] == 3);
	    assert(b5[0] == 4); assert(b5[1] == 5);
	    assert(b6[0][0] == 17); assert(b6[0][1] == 17);
	    assert(b6[1][0] == 25); assert(b6[1][1] == 17);
	    notify e1, e2; wait e1, e2;
	    assert(b4[0] == 1); assert(b4[1] == 3);
	    assert(b5[0] == 2); assert(b5[1] == 5);
	    assert(b6[0][0] == 2); assert(b6[0][1] == 3);
	    assert(b6[1][0] == 4); assert(b6[1][1] == 5);
	}

	{
	    buffered[e1] bit[8] v1;
	    buffered[e1] bit[8] v4[2];
	    buffered[e1] bit[8] v6[2][2];

	    if (!(b1)) { assert(false); }
	    if (!(b4[0])) { assert(false); }
	    if (!(b6[1][1])) { assert(false); }
	    v1 = b1;
	    v4[0] = b4[0];
	    v6[1][1] = b6[1][1];
	    notify e1; wait e1;
	    if (!(v1)) { assert(false); }
	    if (!(v4[0])) { assert(false); }
	    if (!(v6[1][1])) { assert(false); }
	    if (!(v1[0])) { assert(false); }
	    if (!(v4[0][0])) { assert(false); }
	    if (!(v6[1][1][0])) { assert(false); }
	}
    }
};


struct S { int a, b, c; };

behavior Struct
{
    void main(void)
    {
	event e1;
	buffered[e1] struct S bs1 = { 0,1,2 };
	buffered[e1] struct S bs2 = { 4,5,6 };

	assert(bs1.a == 0);
	assert(bs1.b == 1);
	assert(bs1.c == 2);
	bs1.a = 1; bs1.b = 2;
	assert(bs1.a == 0);
	assert(bs1.b == 1);
	notify e1; wait e1;
	bs1.a = bs1.b; bs1.b = bs1.a;
	assert(bs1.a == 1);
	assert(bs1.b == 2);
	notify e1; wait e1;
	bs1.a = 42; bs1.b = 42;
	assert(bs1.a == 2);
	assert(bs1.b == 1);
	notify e1; wait e1;
	assert(bs1.a == 42);
	assert(bs1.b == 42);
	bs1.a = bs1.b - 17;
	bs1.b -= 25;
	assert(bs1.a == 42);
	assert(bs1.b == 42);
	notify e1; wait e1;
	assert(bs1.a == 25);
	assert(bs1.b == 17);

	assert(bs1.a == 25);
	assert(bs1.b == 17);
	assert(bs1.c == 2);
	assert(bs2.a == 4);
	assert(bs2.b == 5);
	assert(bs2.c == 6);
	bs1 = bs2;
	bs2 = bs1;
	assert(bs1.a == 25);
	assert(bs1.b == 17);
	assert(bs1.c == 2);
	assert(bs2.a == 4);
	assert(bs2.b == 5);
	assert(bs2.c == 6);
	notify e1; wait e1;
	assert(bs1.a == 4);
	assert(bs1.b == 5);
	assert(bs1.c == 6);
	assert(bs2.a == 25);
	assert(bs2.b == 17);
	assert(bs2.c == 2);
    }
};


behavior Main
{
    event		e;
    buffered[e] int	b1, b2, b3;
    Buffer		B1(b1, b2, b3);
    Struct		B2;

    int main(void)
    {
	puts("Buffer test starting...");

	puts("Running test 1 (behavior 'Buffer')...");
	B1.main();
	puts("OK. Done.");

	puts("Running test 2 (behavior 'Struct')...");
	B2.main();
	puts("OK. Done.");

	puts("Buffer test completed.");
	return(0);
    }
};

// eof
