// BufSlice.sc

#include "../../inc/sim.sh"	// #include <sim.sh>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

behavior Nibble(
	out event CLK,
	inout buffered bit[4] n)
{
    void main(void)
    {
	char	Buffer[5];
	bit[4]	n30;

//	printf("Nibble @ %2s: n = %s\n",
//			time2str(now()), ubit2str(2, &Buffer[5], n));
	n30 = n[3:0];
	printf("Nibble @ %2s: n[3:0] = %s\n",
			time2str(now()), ubit2str(2, &Buffer[5], n30));
	assert(n30 == 1111b);

	n[3:0] = 0101b;
	waitfor 1;
//	printf("Nibble @ %2s: n = %s\n",
//			time2str(now()), ubit2str(2, &Buffer[5], n));
	n30 = n[3:0];
	printf("Nibble @ %2s: n[3:0] = %s\n",
			time2str(now()), ubit2str(2, &Buffer[5], n30));
	assert(n30 == 1111b);

	notify CLK;
	waitfor 1;
//	printf("Nibble @ %2s: n = %s\n",
//			time2str(now()), ubit2str(2, &Buffer[5], n));
	n30 = n[3:0];
	printf("Nibble @ %2s: n[3:0] = %s\n",
			time2str(now()), ubit2str(2, &Buffer[5], n30));
	assert(n30 == 0101b);
    }
};

behavior Main
{
    event CLK;
    buffered[CLK] bit[8] b = 11111111b;
    Nibble n1(CLK, b[3:0]);

    int main(void)
    {
	char	Buffer[9];

	printf("before: b = %s\n", ubit2str(2, &Buffer[9], b));
	assert(b == 11111111b);
	n1;
	printf("after:  b = %s\n", ubit2str(2, &Buffer[9], b));
	assert(b == 11110101b);

//	b = 00000000b;
//	notify CLK;
//	waitfor 8;

//	printf("before: b = %s\n", ubit2str(2, &Buffer[9], b));
//	assert(b == 00000000b);
//	n1;
//	printf("after:  b = %s\n", ubit2str(2, &Buffer[9], b));
//	assert(b == 00000101b);

	return(0);
    }
};

// EOF
