// i_critical_section.sc: provides protected access to a critical section
// (only one thread at a time can operate in the critical section)
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/12/02 RD	applied naming convention, integrated with distribution
// 01/23/02 RD	initial version (based on mutex.sc)
//
//
// interface rules:
//
// - each thread must call enter() before entering the critical section
//   and call leave() after leaving the critical section
// - calling leave() without prior call to enter() is illegal
// - calling enter() twice without leave() in between is illegal
// - calling leave() twice without enter() in between is illegal
// - calling enter() may suspend the calling thread indefinitely
// - if a thread needs to enter multiple critical sections at the
//   same time, a global partial order of entering the sections
//   should be used, otherwise deadlock situations may occur


interface i_critical_section
{
    void enter(void);
    void leave(void);
};


// EOF i_critical_section.sc
