// i_send.sc: sender interface for one-way handshake
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 10/24/02 RD	replaced "signal" with "handshake" to avoid confusion
// 02/18/02 RD	applied naming convention, integrated with distribution
// 02/06/02 RD	generalized capabilities, fixed usage rules
// 01/31/02 RD	separated interface into send an receive interfaces
// 01/23/02 RD	brush up, moved into separate file "handshake.sc"
// 12/27/01 RD	initial version
//
//
// interface rules:
//
// - a connected thread acts as a sender
// - a call to send() sends a handshake to the receiver; if the receiver
//   is waiting at the time of the send(), it will wake up and resume
//   its execution; otherwise, the handshake is stored until the receiver
//   calls receive()
// - calling send() will not suspend the calling thread


interface i_send
{
    void send(void);
};


// EOF i_send.sc
