// typed_queue.sc: example for use of c_typed_queue
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 04/25/03 RD	adjusted code to new receiver interface in channel library
// 02/15/02 RD	initial version (based on typed_queue_test2.sc)


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>


import "c_bit64_queue";		// import the INSTANTIATED standard channel
//import "c_bit64_queue_dbg";	// use this to debug the channel!


const unsigned long SIZE = 20;	// number of spaces available in the queue

const long N             = 100;	// number of read and write transactions


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((int)(drand48() * (double)Range));
}


behavior Sender(		// the sender behavior
    i_bit64_sender Queue)
{
    void SendData(int s)
    {
	bit[64] Data;

	printf("Time%4s: Sender storing data %d.\n",
		time2str(now()), s);
	Data = s;
	Queue.send(Data);
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Sender done, ",
		time2str(now()));
	Duration = Rnd(10);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int s;

	for(s=1; s<=N; s++)
	{
	    SendData(s);
	    Sleep();
	}
    }
};


behavior Receiver(		// the receiver behavior
    i_bit64_receiver Queue)
{
    void ReceiveData(int r)
    {
	bit[64] Data;

	printf("Time%4s: Receiver loading data %d.\n",
		time2str(now()), r);
	Queue.receive(&Data);
	assert(Data == r);
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Receiver done, ",
		time2str(now()));
	Duration = Rnd(10);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int r;

	for(r=1; r<=N; r++)
	{
	    ReceiveData(r);
	    Sleep();
	}
    }
};


behavior Main	// let the sender send data to the receiver through the queue
{
    c_bit64_queue Queue((SIZE));
    Receiver      r1(Queue);
    Sender        s1(Queue);

    int main(void)
    {
	printf("Time%4s: typed_queue: Starting...\n",
		time2str(now()));
	par {	r1.main();
		s1.main();
		}
	printf("Time%4s: typed_queue: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF typed_queue.sc
