// Testbench.sc


#include <stdlib.h>
#include <stdio.h>


import "ADD08_1";
import "ADD16_1";
import "ADD32_1";

import "ADD08_2";
import "ADD16_2";
import "ADD32_2";


behavior Main		// test bench for the adders
{
	bit[8]	In08_1,
		In08_2,
		Out08;
	bit[16]	In16_1,
		In16_2,
		Out16;
	bit[32]	In32_1,
		In32_2,
		Out32;

	ADD08_1	Add08_1(0b, In08_1, In08_2, Out08, );
	ADD16_1	Add16_1(0b, In16_1, In16_2, Out16, );
	ADD32_1	Add32_1(0b, In32_1, In32_2, Out32, );

	ADD08_2	Add08_2(0b, In08_1, In08_2, Out08, );
	ADD16_2	Add16_2(0b, In16_1, In16_2, Out16, );
	ADD32_2	Add32_2(0b, In32_1, In32_2, Out32, );

	int main(int argc, char **argv)
	{
	int	a,
		b;
	bit[8]	s08;
	bit[16]	s16;
	bit[33]	s32;

	if (argc == 3)
	   { a = atoi(argv[1]);
	     b = atoi(argv[2]);
	    }
	else
	   { a = 27;
	     b = 15;
	    }

	printf("Adder 1 (8-bit):  %d + %d =", a, b);
	In08_1 = a; In08_2 = b;
	Add08_1.main();
	printf(" %d", (int)Out08);
	s08 = In08_1 + In08_2;
	if (Out08 != s08)
	   { printf(" FALSE!!! (should be %d)\n", (int)s08);
	     return(10);
	    } /* fi */
	printf(" (correct)\n");

	printf("Adder 2 (16-bit): %d + %d =", a, b);
	In16_1 = a; In16_2 = b;
	Add16_1.main();
	printf(" %d", (int)Out16);
	s16 = In16_1 + In16_2;
	if (Out16 != s16)
	   { printf(" FALSE!!! (should be %d)\n", (int)s16);
	     return(10);
	    } /* fi */
	printf(" (correct)\n");

	printf("Adder 3 (32-bit): %d + %d =", a, b);
	In32_1 = a; In32_2 = b;
	Add32_1.main();
	printf(" %d", (int)Out32);
	s32 = In32_1 + In32_2;
	if (Out32 != s32)
	   { printf(" FALSE!!! (should be %d)\n", (int)s32);
	     return(10);
	    } /* fi */
	printf(" (correct)\n");

	printf("Adder 4 (8-bit):  %d + %d =", a, b);
	In08_1 = a; In08_2 = b;
	Add08_2.main();
	printf(" %d", (int)Out08);
	s08 = In08_1 + In08_2;
	if (Out08 != s08)
	   { printf(" FALSE!!! (should be %d)\n", (int)s08);
	     return(10);
	    } /* fi */
	printf(" (correct)\n");

	printf("Adder 5 (16-bit): %d + %d =", a, b);
	In16_1 = a; In16_2 = b;
	Add16_2.main();
	printf(" %d", (int)Out16);
	s16 = In16_1 + In16_2;
	if (Out16 != s16)
	   { printf(" FALSE!!! (should be %d)\n", (int)s16);
	     return(10);
	    } /* fi */
	printf(" (correct)\n");

	printf("Adder 6 (32-bit): %d + %d =", a, b);
	In32_1 = a; In32_2 = b;
	Add32_2.main();
	printf(" %d", (int)Out32);
	s32 = In32_1 + In32_2;
	if (Out32 != s32)
	   { printf(" FALSE!!! (should be %d)\n", (int)s32);
	     return(10);
	    } /* fi */
	printf(" (correct)\n");

	return(0);
	}
};

// EOF
