// c_packet_double_handshake.sc:
// instantiation of template c_typed_double_handshake.sh
// with type 'struct packet'
//
// author:      Rainer Doemer
// last update: 04/25/03

// note:
// this file "instantiates" the "templates" for type 'struct packet';
// the "templates" are actually implemented as preprocessor macros;
// they can be "instantiated" by calling the macro with parameters;
//
// if this file is fed through the SpecC compiler such that
// SpecC code is re-generated, the "magic" behind the macros
// becomes visible; this is very useful for debugging;
// please see the file "c_packet_double_handshake_dbg.sc";


#include <c_typed_double_handshake.sh>	/* make the template available */

struct packet	/* define our packet data type */
{
    int        i;
    bool       b;
    char       c;
    float      f;
    bit[42]    v;
    long       a[10];
};

// define the sender interface for data type 'struct packet'
DEFINE_I_TYPED_SENDER(packet, struct packet)

// define the receiver interface for data type 'struct packet'
DEFINE_I_TYPED_RECEIVER(packet, struct packet)

// define the tranceiver interface for data type 'struct packet'
DEFINE_I_TYPED_TRANCEIVER(packet, struct packet)

// define the double_handshake channel for data type 'struct packet'
DEFINE_C_TYPED_DOUBLE_HANDSHAKE(packet, struct packet)


// EOF c_packet_double_handshake.sc
