// token_test4.sc: test bench for c_token.sc
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/12/02 RD	applied naming convention, integrated with distribution
// 02/07/02 RD	initial version, two sender threads and two receiver threads


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sim.sh>


#define N		300	// total number of tokens fired
				// (must be an even number!)

import "c_token";


int Rnd(int Range)		// random number in range [0...Range-1]
{
    return((unsigned int)(drand48() * (double)Range));
}


behavior Producer(
    i_producer Token,
    in int     ID)
{
    void ProduceToken(int s)
    {
	printf("Time%4s: Producer %d producing %d tokens.\n",
		time2str(now()), ID, s);
	Token.produce(s);
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Producer %d done, ",
		time2str(now()), ID);
	Duration = Rnd(10);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int s = 0,
	    t;

	while (s < N/2)
	{
	    if (N/2-s > 10)
	    {
		t = Rnd(10)+1;
	    }
	    else
	    {
		t = Rnd(N/2-s)+1;
	    }
	    ProduceToken(t);
	    s += t;
	    Sleep();
	}
    }
};


behavior Consumer(
    i_consumer Token,
    in int     ID)
{
    void ConsumeToken(int r)
    {
	printf("Time%4s: Consumer %d consuming %d tokens.\n",
		time2str(now()), ID, r);
	Token.consume(r);
    }

    void Sleep(void)
    {
	int Duration;

	printf("Time%4s: Consumer %d done, ",
		time2str(now()), ID);
	Duration = Rnd(10);
	printf("going to sleep for %d time units.\n", Duration);
	if (Duration)
	    waitfor(Duration);
    }

    void main(void)
    {
	int r = 0,
	    t;

	while (r < N/2)
	{
	    if (N/2-r > 10)
	    {
		t = Rnd(10)+1;
	    }
	    else
	    {
		t = Rnd(N/2-r)+1;
	    }
	    ConsumeToken(t);
	    r += t;
	    Sleep();
	}
    }
};


behavior Main			// test bench for token
{
    c_token   Token;
    Consumer  r1(Token, 1),
              r2(Token, 2);
    Producer  s1(Token, 1),
              s2(Token, 2);

    int main(void)
    {
	printf("Time%4s: token_test4: Starting...\n",
		time2str(now()));
	printf("Time%4s: Running 2 consumers, 2 producers.\n",
		time2str(now()));
	par {	r1.main();
		r2.main();
		s1.main();
		s2.main();
		}
	printf("Time%4s: token_test4: Done.\n",
		time2str(now()));
	return 0;
    }
};


// EOF token_test4.sc
