// i_barrier.sc: provides barrier synchronization between N threads
// (rendezvous between N threads)
//
// author: Rainer Doemer
//
// modifications: (most recent first)
//
// 02/12/02 RD	applied naming convention, integrated with distribution
// 02/06/02 RD	initial version
//
//
// interface rules:
//
// - each participating thread calls barrier() to synchronize with the
//   other participating threads at the barrier
// - a call to barrier() will suspend the calling thread until all
//   other participating threads have arrived at the barrier; then,
//   all participating treads resume their execution
// - calling barrier() may suspend the calling thread indefinitely


interface i_barrier
{
    void barrier(void);
};


// EOF i_barrier.sc
