// try5.sc

#include <sim.sh>

#include <stdio.h>
#include <assert.h>

behavior Try
{
	void main(void)
	{
	waitfor 10;
	}
};

behavior TrapA(inout int x)
{
	void main(void)
	{
	x++;
	}
};

behavior TrapB(inout int y)
{
	void main(void)
	{
	y++;
	}
};

behavior InterruptA(inout int x)
{
	void main(void)
	{
	x++;
	}
};

behavior InterruptB(inout int y)
{
	void main(void)
	{
	y++;
	}
};

behavior Exception(inout int x, inout int y,
		in event e1, in event e2, in event e3, in event e4)
{
	Try		t;
	TrapA		ta(x);
	TrapB		tb(y);
	InterruptA	ia(x);
	InterruptB	ib(y);

	void main(void)
	{
	try {	t.main();
		}
		trap e1
		    {	ta.main();
			}
		trap e2
		    {	tb.main();
			}
		interrupt e3
		    {	ia.main();
			}
		interrupt e4
		    {	ib.main();
			};
	}
};

behavior Trigger(out event e1, out event e2)
{
	void main(void)
	{
	waitfor 5;
	notifyone e1, e2;
	}
};

behavior Main
{
	event		e1, e2, e3, e4;
	int		x = 0;
	int		y = 0;

	Exception	e(x, y, e1, e2, e3, e4);
	Trigger		t12(e1, e2),
			t23(e2, e3),
			t34(e3, e4),
			t13(e1, e3),
			t24(e2, e4);

	int main(void)
	{
	puts("try5: Starting...");

	par {	e.main();
		t12.main();
		}
	assert(x == 1);
	assert(y == 0);
	assert(now() == 5);

	par {	e.main();
		t23.main();
		}
	assert(x == 1);
	assert(y == 1);
	assert(now() == 10);

	par {	e.main();
		t34.main();
		}
	assert(x == 2);
	assert(y == 1);
	assert(now() == 20);

	par {	e.main();
		t13.main();
		}
	assert(x == 3);
	assert(y == 1);
	assert(now() == 25);

	par {	e.main();
		t24.main();
		}
	assert(x == 3);
	assert(y == 2);
	assert(now() == 30);

	puts("try5: Done.");
	return(0);
	}
};

// EOF
