// notifyone3.sc

#include <stdio.h>
#include <assert.h>

behavior A(out event e1, in event e2, in int x, inout int y)
{
	void main(void)
	{
	y = x + 1;
	assert(y == 1);
	notifyone e1;
	wait e2;

	y = x + 1;
	assert(y == 3);
	notifyone e1;
	wait e2;

	y = x + 1;
	assert(y == 5);
	notifyone e1;
	wait e2;
	}
};

behavior B(in event e1, out event e2, inout int x, in int y)
{
	void main(void)
	{
	wait e1;

	x = y + 1;
	assert(x == 2);
	notifyone e2;
	wait e1;

	x = y + 1;
	assert(x == 4);
	notifyone e2;
	wait e1;

	x = y + 1;
	assert(x == 6);
	notifyone e2;
	}
};

behavior Main
{
	event	e1, e2;
	int	x = 0;
	int	y = 0;
	A	a(e1, e2, x, y);
	B	b(e1, e2, x, y);

	int main(void)
	{
	puts("notifyone3: Starting...");

	par {	a.main();
		b.main();
		};
	assert(x == 6);

	x = 0;
	par {	b.main();
		a.main();
		};
	assert(x == 6);

	puts("notifyone3: Done.");
	return(0);
	}
};

// EOF
