/************************************************************************/
/* PosixThread.h: SpecC thread implementation based on Posix Threads	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 03/26/01 */
/************************************************************************/

/* last update: 10/21/04 */

/* modifications: (most recent first)
 *
 * 10/21/04 RD	pass SIM_THREAD_STACK_SIZE from outside
 * 10/04/04 RD	introduced SIM_THREAD_STACK_SIZE
 * 06/15/04 PC  Adjustments for scrc 2.0
 * 04/12/04 RD	moved RunningThread into the thread_base class
 * 12/10/01 RD	introduced explicit return type of thread function
 * 05/16/01 RD	separated common thread code (in thread.[h|cc]) from
 *		platform-specific thread code (in PosixThread.[h|cc])
 * 03/26/01 RD	initial version
 */

#ifndef POSIX_THREAD_H
#define POSIX_THREAD_H

#include <pthread.h>

#include "specc.h"


/*** constants and macros ***********************************************/


#ifndef SIM_THREAD_STACK_SIZE		// default value (if not passed from outside):
#define SIM_THREAD_STACK_SIZE	64*1024	// stack size for each thread
#endif /* SIM_THREAD_STACK_SIZE */


/*** type definitions ***************************************************/


typedef void *(*thread_fct)(void *);	/* thread function type */
typedef void *thread_ret;		/* thread function return type */
typedef void *thread_arg;		/* thread function argument type */


/*** class declarations *************************************************/


	/***************************/
	/*** _specc::thread_base ***/
	/***************************/


class _specc::thread_base	/* base class for threads */
{
public:
thread_fct	ThreadFunction;	/* function performed by the thread */
thread_arg	ThreadArg;	/* argument to the function peformed */
thread_base	*ThreadCreator;	/* creator thread (only valid at creation) */
pthread_t	ThreadHandle;	/* handle for posix thread */
pthread_cond_t	CondVar;	/* condition variable to wake up this thread */

static thread_base	*RunningThread;	/* the running thread (or NULL) */


thread_base(			/* constructor #1 */
	thread_base	*Creator);

~thread_base(void);		/* destructor */


static void ThreadStart(void);	/* initialize thread usage */

static void ThreadEnd(void);	/* clean up after thread usage */

void ThreadCreate(		/* create this new thread */
	thread_fct	Function,	/* (NULL for root thread) */
	thread_arg	Arg);		/* (NULL for root thread) */

void ThreadDelete(void);	/* delete this thread */

void ThreadJoin(		/* wait for another thread to complete */
	thread_base	*Thread);

void ThreadAbort(void);		/* abort this thread (force completion) */

void ThreadRun(			/* transfer control to another thread */
	thread_base	*Thread);
};


/*** exported variables *************************************************/


	/* none */


/************************************************************************/
/*** prototype definitions for exported functions		      ***/
/************************************************************************/


	/* none */


#endif /* POSIX_THREAD_H */

/* EOF PosixThread.h */
