// Signal2.sc: (updated 01/06/03, initial version 11/26/02, RD)

#include <stdio.h>
#include <assert.h>

behavior Signal(
	in    signal int SignalIn,
	out   signal int SignalOut,
	inout signal int SignalIO)
{
    void main(void)
    {
	signal int s1 = 0,
	           s2 = 1,
	           s3;
	signal int s4[2] = { 0, 1ull };
	signal int s5[2] = { 5, 5 };
	signal int s6[2][2] = {{1,2}, {3,4}};

	assert(s1 == 0);
	assert(s2 == 1);
	s1 = 1; s2 = 2;
	assert(s1 == 0);
	assert(s2 == 1);
	wait s1 rising && s2;
	s1 = s2; s2 = s1;
	assert(s1 == 1);
	assert(s2 == 2);
	wait s1 && s2;
	s1 = 42; s2 = 42;
	assert(s1 == 2);
	assert(s2 == 1);
	wait s1 && s2;
	assert(s1 == 42);
	assert(s2 == 42);
	s1 = s2 - 17;
	s2 -= 25;
	assert(s1 == 42);
	assert(s2 == 42);
	wait s1 && s2;
	assert(s1 == 25);
	assert(s2 == 17);

	assert(s4[0] == 0);
	assert(s4[1] == 1);
	s4[0] = 1; s4[1] = 2;
	assert(s4[0] == 0);
	assert(s4[1] == 1);
	wait s4;
	s4[0] = s4[1]; s4[1] = s4[0];
	assert(s4[0] == 1);
	assert(s4[1] == 2);
	wait s4;
	s4[0] = 42; s4[1] = 42;
	assert(s4[0] == 2);
	assert(s4[1] == 1);
	wait s4;
	assert(s4[0] == 42);
	assert(s4[1] == 42);
	s4[0] = s4[1] - 17;
	s4[1] -= 25;
	assert(s4[0] == 42);
	assert(s4[1] == 42);
	wait s4;
	assert(s4[0] == 25);
	assert(s4[1] == 17);

	assert(s4[0] == 25); assert(s4[1] == 17);
	assert(s5[0] ==  5); assert(s5[1] ==  5);
	s5 = s4;
	assert(s4[0] == 25); assert(s4[1] == 17);
	assert(s5[0] ==  5); assert(s5[1] ==  5);
	wait s5;
	assert(s4[0] == 25); assert(s4[1] == 17);
	assert(s5[0] == 25); assert(s5[1] == 17);
	s5[1] = s4[0];
	s5[0] = s4[1];
	assert(s4[0] == 25); assert(s4[1] == 17);
	assert(s5[0] == 25); assert(s5[1] == 17);
	wait s5;
	assert(s4[0] == 25); assert(s4[1] == 17);
	assert(s5[0] == 17); assert(s5[1] == 25);

	assert(s6[0][0] ==  1); assert(s6[0][1] ==  2);
	assert(s6[1][0] ==  3); assert(s6[1][1] ==  4);
	s6[0][0] = -1; s6[1][1] = -2;
	assert(s6[0][0] ==  1); assert(s6[0][1] ==  2);
	assert(s6[1][0] ==  3); assert(s6[1][1] ==  4);
	wait s6;
	assert(s6[0][0] == -1); assert(s6[0][1] ==  2);
	assert(s6[1][0] ==  3); assert(s6[1][1] == -2);
	s6[1] = s5;
	assert(s6[0][0] == -1); assert(s6[0][1] ==  2);
	assert(s6[1][0] ==  3); assert(s6[1][1] == -2);
	wait s6;
	assert(s6[0][0] == -1); assert(s6[0][1] ==  2);
	assert(s6[1][0] == 17); assert(s6[1][1] == 25);
	s6[0][0]++; s6[0][1] -= 2;
	s6[1][0] = s6[1][1]; s6[1][1] = s6[1][0];
	assert(s6[0][0] == -1); assert(s6[0][1] ==  2);
	assert(s6[1][0] == 17); assert(s6[1][1] == 25);
	wait s6;
	assert(s6[0][0] ==  0); assert(s6[0][1] ==  0);
	assert(s6[1][0] == 25); assert(s6[1][1] == 17);

	s4[0] = s2; s2 = s4[0];
	assert(s4[0] == 25); assert(s4[1] == 17); assert(s2 == 17);
	wait s4 && s2;
	assert(s4[0] == 17); assert(s4[1] == 17); assert(s2 == 25);
	s6[0] = s4; s4 = s6[0];
	assert(s6[0][0] ==  0); assert(s6[0][1] ==  0);
	assert(s4[0] == 17); assert(s4[1] == 17);
	wait s6 && s4;
	assert(s6[0][0] == 17); assert(s6[0][1] == 17);
	assert(s4[0] ==  0); assert(s4[1] ==  0);

	{
	    event e1;
	    buffered[e1] int b1 = 1;
	    buffered[e1] int b2[2] = { 2, 3 };
	    buffered[e1] int b3[2][2] = {{4,5}, {6,7}};

	    s1 = b1;
	    s2 = b2[0];
	    s4 = b2;
	    s5 = b3[0];
	    assert(s1 == 25);
	    assert(s2 == 25);
	    assert(s4[0] ==  0); assert(s4[1] ==  0);
	    assert(s5[0] == 17); assert(s5[1] == 25);
	    wait s1 && s2 && s4 && s5;
	    assert(s1 == 1);
	    assert(s2 == 2);
	    assert(s4[0] == 2); assert(s4[1] == 3);
	    assert(s5[0] == 4); assert(s5[1] == 5);

	    s4[0] = b1;
	    s5[0] = b2[0];
	    s6[0] = b2;
	    s6[1] = b3[0];
	    assert(s4[0] == 2); assert(s4[1] == 3);
	    assert(s5[0] == 4); assert(s5[1] == 5);
	    assert(s6[0][0] == 17); assert(s6[0][1] == 17);
	    assert(s6[1][0] == 25); assert(s6[1][1] == 17);
	    wait s4 && s5 && s6;
	    assert(s4[0] == 1); assert(s4[1] == 3);
	    assert(s5[0] == 2); assert(s5[1] == 5);
	    assert(s6[0][0] == 2); assert(s6[0][1] == 3);
	    assert(s6[1][0] == 4); assert(s6[1][1] == 5);
	}

	{
	    signal bit[8] b1;
	    signal bit[8] b4[2];
	    signal bit[8] b6[2][2];

	    if (!(s1)) { assert(false); }
	    if (!(s4[0])) { assert(false); }
	    if (!(s6[1][1])) { assert(false); }
	    b1 = s1;
	    b4[0] = s4[0];
	    b6[1][1] = s6[1][1];
	    wait b1 && b4 && b6;
	    if (!(b1)) { assert(false); }
	    if (!(b4[0])) { assert(false); }
	    if (!(b6[1][1])) { assert(false); }
	    if (!(b1[0])) { assert(false); }
	    if (!(b4[0][0])) { assert(false); }
	    if (!(b6[1][1][0])) { assert(false); }
	}
    }
};


struct S { int a, b, c; };

behavior Struct
{
    void main(void)
    {
	signal struct S ss1 = { 0,1,2 };
	signal struct S ss2 = { 4,5,6 };

	assert(ss1.a == 0);
	assert(ss1.b == 1);
	assert(ss1.c == 2);
	ss1.a = 1; ss1.b = 2;
	assert(ss1.a == 0);
	assert(ss1.b == 1);
	wait ss1;
	ss1.a = ss1.b; ss1.b = ss1.a;
	assert(ss1.a == 1);
	assert(ss1.b == 2);
	wait ss1;
	ss1.a = 42; ss1.b = 42;
	assert(ss1.a == 2);
	assert(ss1.b == 1);
	wait ss1;
	assert(ss1.a == 42);
	assert(ss1.b == 42);
	ss1.a = ss1.b - 17;
	ss1.b -= 25;
	assert(ss1.a == 42);
	assert(ss1.b == 42);
	wait ss1;
	assert(ss1.a == 25);
	assert(ss1.b == 17);

	assert(ss1.a == 25);
	assert(ss1.b == 17);
	assert(ss1.c == 2);
	assert(ss2.a == 4);
	assert(ss2.b == 5);
	assert(ss2.c == 6);
	ss1 = ss2;
	ss2 = ss1;
	assert(ss1.a == 25);
	assert(ss1.b == 17);
	assert(ss1.c == 2);
	assert(ss2.a == 4);
	assert(ss2.b == 5);
	assert(ss2.c == 6);
	wait ss1 && ss2;
	assert(ss1.a == 4);
	assert(ss1.b == 5);
	assert(ss1.c == 6);
	assert(ss2.a == 25);
	assert(ss2.b == 17);
	assert(ss2.c == 2);
    }
};


behavior Main
{
    signal int s1, s2, s3;
    Signal S1(s1, s2, s3);
    Struct S2;

    int main(void)
    {
	puts("Signal test starting...");

	puts("Running test 1 (behavior 'Signal')...");
	S1.main();
	puts("OK. Done.");

	puts("Running test 2 (behavior 'Struct')...");
	S2.main();
	puts("OK. Done.");

	puts("Signal test completed.");
	return(0);
    }
};

// eof
