// Pipeline3.sc
//
// created 09/07/01 as test case for bug report: piped bitvectors didn't work!

#include <stdio.h>
#include <stdlib.h>
#include "../../inc/sim.sh"	// #include <sim.sh>

behavior Stage1(out bit[99] p1, out bit[99] p2, in bit[99] p3)
{
	bit[99]	Stage1ExecCount = 0;

	void main(void)
	{
	bit[99]	t1, t2;

	Stage1ExecCount++;
	printf("Stage1 execution #%d at time %d\n",
		(int)Stage1ExecCount, (int)now());
	printf("Stage1 input:  p3 = %d\n", (int)p3);
	t1 = p3 + 1000 + 10000 * Stage1ExecCount;
	t2 = p3 + 2000 + 10000 * Stage1ExecCount;
	printf("Stage1 output: p1 = %d, p2 = %d\n", (int)t1, (int)t2);
	waitfor(5);
	p1 = t1;
	p2 = t2;
	}
};


behavior Stage2(in bit[99] p1, out bit[99] p2)
{
	bit[99]	Stage2ExecCount = 0;

	void main(void)
	{
	bit[99]	t;

	Stage2ExecCount++;
	printf("Stage2 execution #%d at time %d\n",
		(int)Stage2ExecCount, (int)now());
	printf("Stage2 input:  p1 = %d\n", (int)p1);
	t = p1 + 100000 * Stage2ExecCount;
	printf("Stage2 output: p2 = %d\n", (int)t);
	waitfor(10);
	p2 = t;
	}
};


behavior Stage3(in bit[99] p1, in bit[99] p2, out bit[99] p3)
{
	bit[99]	Stage3ExecCount = 0;

	void main(void)
	{
	bit[99]	t;

	Stage3ExecCount++;
	printf("Stage3 execution #%d at time %d\n",
		(int)Stage3ExecCount, (int)now());
	printf("Stage3 input:  p1 = %d, p2 = %d\n", (int)p1, (int)p2);
	t = p1 + p2;
	printf("Stage3 output: p3 = %d\n", (int)t);
	waitfor(7);
	p3 = t;
	}
};


behavior Pipeline(in bit[99] a, out bit[99] b)
{
	piped bit[99]		From1To2,
				From2To3;
	piped piped bit[99]	From1To3;

	Stage1	s1(From1To2, From1To3, a);
	Stage2	s2(From1To2, From2To3);
	Stage3	s3(From1To3, From2To3, b);

	void main(void)
	{
	int	i;

	pipe(i=0; i<10; i++)
	   {	s1.main();
		s2.main();
		s3.main();
		}
	}
};


behavior Main		/* Main behavior */
{
	bit[99]		i, o;
	Pipeline	p(i, o);

	int main(void)
	{
	puts("Pipeline2:");
	i = 42;
	printf("Pipeline input:  %d\n", (int)i);
	p.main();
	printf("Pipeline output: %d\n", (int)o);
	puts("Exiting...");

	return(0);
	}
};

// EOF
