// Kanji.sc: Japanese kanji (2-byte) encodings test file
// (samples from Araki and Ishii)

// Note: (S)JIS is the PC-style (MSDOS, IBM, etc.) encoding
//	 EUC is the Extended Unix Code (similar to ISO-LATIN)


// JIS example 1: Jn


char *String1a = "This is Jn\n";

// JIS example 2: 1


char *String2a = "This is 1\n";

// JIS example 3: Xe[gQ


char *String3a = "This is Xe[gQ\n";

// JIS example 4: I


char *String4a = "This is I\n";



// EUC example 1: О̞

char *String1b = "This is О̞\n";

// EUC example 2: о1

char *String2b = "This is о1\n";

// EUC example 3: Ü

char *String3b = "This is Ü\n";

// EUC example 4: Ͻ

char *String4b = "This is Ͻ\n";


// the following examples only work correctly
// if scrc is compiled with KANJI support enabled
// (kanji- and backslash- escape code conflict)

// conflict 1: Xpx\

char *String1c = "This is Xpx\\n";

// conflict 2: Ypx\

char *String2c = "This is Ypx\\n";


// "Hankaku Kana":
// Japanese 1-byte code provided by Nakamura (Dec 2004)
 
char *Hankaku_Kana_1 = ("");
char *Hankaku_Kana_2 = ("");
char *Hankaku_Kana_3 = ("");
char *Hankaku_Kana_4 = ("");
char *Hankaku_Kana_5 = ("");
char *Hankaku_Kana_6 = ("");
char *Hankaku_Kana_7 = ("");
char *Hankaku_Kana_8 = ("");
char *Hankaku_Kana_9 = ("");

// EOF
