/************************************************************************/
/* IntRep/Parameter.h: SpecC Internal Representation, Parameter Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 02/10/98 */
/************************************************************************/

/* last update: 09/26/06 */

/* modifications: (most recent first)
 *
 * 09/26/06 PC  Adjustments for scrc 2.1
 * 06/03/05 RD	reorganized and renamed global type names
 * 05/31/01 RD	eliminated level 2 of SIR API
 * 05/26/01 RD	eliminated support for binary SIR files (import/export)
 * 05/25/01 RD	introduced this header (last change was 12/16/98)
 */

#ifndef INTREP_PARAMETER_H
#define INTREP_PARAMETER_H


#include "Global.h"
#include "IntRep/List.h"


/*** enumeration types **************************************************/


	/* none */


/*** type definitions ***************************************************/


typedef class SIR_Parameter		sir_parameter;
typedef SIR_List<sir_parameter>		sir_param_list;
typedef class SIR_Parameters		sir_parameters;

typedef class SIR_Symbol		sir_symbol;	/* cyclic link */
typedef class SIR_Type			sir_type;	/* cyclic link */
typedef class SIR_TypePtr		sir_type_ptr;	/* cyclic link */
typedef class SIR_TypePtrs		sir_type_ptrs;	/* cyclic link */


/*** class declarations *************************************************/


	/*********************/
	/*** SIR_Parameter ***/
	/*********************/


class SIR_Parameter :		/* function parameter (or beh./chan. port) */
	public SIR_ListElem<SIR_Parameter>	/* is a list element */
{
public:
sir_type	*Type;		/* link to type table entry */
sir_symbol	*Symbol;	/* link to symbol table entry (or NULL) */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Parameter(			/* constructor #1 (general) */
	sir_type	*Type,
	sir_symbol	*Symbol = NULL);

SIR_Parameter(			/* constructor #3 (duplicator) */
	sir_parameter	*Original);

~SIR_Parameter(void);		/* destructor */
};


	/**********************/
	/*** SIR_Parameters ***/
	/**********************/


class SIR_Parameters :		/* list of parameters (or ports) */
	public SIR_List<SIR_Parameter>	/* is simply a list of parameters */
{					/* with additional member(function)s */
public:

//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Parameters(			/* constructor #1 */
	sir_parameter	*FirstEntry = NULL);

SIR_Parameters(			/* constructor #2 (duplicator) */
	sir_parameters	*Original);

SIR_Parameters(			/* constructor #3 (from type parameters) */
	sir_type_ptrs	*TypeParams);

~SIR_Parameters(void);		/* destructor */


bool IsVoid(void);		/* determines if there are no parameters */


void UnAlias(void);		/* unalias all type, usertype, symbol links */


sir_parameter *Find(		/* find corresponding parameter */
	sir_type_ptrs	*TypeParams,	/* (returns NULL if not found) */
	sir_type_ptr	*TypePtr);
};


/*** exported functions *************************************************/


	/* none */


#endif /* INTREP_PARAMETER_H */

/* EOF IntRep/Parameter.h */
