// SigBus.sc
//
// 03/19/03 RD	fixed checking in NibbleMonitor
// 03/12/03 RD	synchronized with BufBus.sc
// 03/05/03 RD	initial version (based on BufBus.sc)

#include "../../inc/sim.sh"	// #include <sim.sh>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

behavior NibbleMonitor(
	in int Num,
	in signal bit[4] Nibble)
{
    void main(void)
    {
	char	Buffer[5];
	bit[8]	CheckByte = 00000001b;
	bit[4]	CheckNibble;

	while(true)
	{
	    wait Nibble;
	    printf("NibbleMonitor %d @ %2s: Nibble is %s%s\n",
				Num, time2str(now()),
				Num == 1 ? "    " : "",
				ubit2str(2, &Buffer[5], Nibble));
	    CheckByte <<= 1;
	    CheckNibble = (Num == 1) ? CheckByte[3:0] : CheckByte[7:4];
	    assert(Nibble == CheckNibble);
	}
    }
};

behavior ByteInit(
	out signal bit[8] Byte)
{
    void main(void)
    {
	event Delta;

	Byte = 00000001b;
	notify Delta;
	wait Delta;
    }
};

behavior ByteStimulus(
	inout signal bit[8] Byte)
{
    void main(void)
    {
	int i;

	assert(Byte == 00000001b);
	for(i=0; i<9; i++)
	{
	    waitfor 1;
	    Byte <<= 1;
	}
	assert(Byte == 00000000b);
	exit(0);	// terminate simulation now
    }
};

behavior Main
{
    signal bit[8] b, b2;
    NibbleMonitor m1(1,b[3:0]);
    NibbleMonitor m2(2,b[7:4]);
    NibbleMonitor m3(3,1111b);	// constant mapping test
    ByteInit      i1(b);
    ByteStimulus  s1(b);
    ByteInit      i2( );	// open mapping test

    int main(void)
    {
	i1;
	par { m1; m2; s1; }
	return(10);	// never reached
    }
};

// EOF
