/* Notes.sc */
/*----------*/

/*** general notes (attached to the design) ***/

note Author	= "Rainer Doemer";
note Date	= "Nov 07, 1997";
note PrevUpdate	= "Mon Apr 20 17:23:08 PDT 1998";
note Update	= "Wed Jan 16 11:21:03 PST 2002";
note Day	= 7;
note Month	= 11;
note Year	= 1900 + 97;
note Date3	= { 2002, 01, 16 };
note Time3	= { 11, 21, 03 };
note TimeStamp	= { { 2002, 01, 16 }, { 11, 21, 03 } };
note Comment1	= "This is an example of how to attach notes to a design.\n"
		  "A note can be any constant expression and can be attached "
		  "to any symbol or label in the description.";
note Comment2	= { "NEW:", {01, 16, 2002},
		    "Annotations now can be of composite type!",
		    "That is, the value of annotations can be structured "
		    "just like complex initializers for arrays or structs.",
		    "This change is effective as of SpecC LRM V2.0." };
note Comment3	= { };	// empty list (allowed 10/31/02, RD)
note Comment4	= { 1, { }, 3 };

note TicTacToe	= { { 1, 0, 1 },
		    { 0, 1, 0 },
		    { 1, 0, 1 } };

note DisplayData =
	{ { "Main", "", {  0,  0,300,100}, "blue1",
	  { { "I",  "i1", { 10, 10, 80, 80}, "red1" },
	    { "T",  "t1", {110, 10, 80, 80}, "yellow1",
	      { "B",  "b1", {120, 20, 60, 20}, "yellow2",
		{ "D",  "d1", {125, 25, 50,  5}, "yellow3" },
		{ "E",  "e1", {125, 35, 50,  5}, "yellow3" } },
	      { "B",  "b2", {120, 60, 60, 20}, "yellow2",
		{ "D",  "d1", {125, 65, 50,  5}, "yellow3" },
		{ "E",  "e1", {125, 75, 50,  5}, "yellow3" } },
	      { "C",  "c1", {120, 80, 60, 20}, "yellow2" } },
	    { "O",  "o1", {210, 10, 80, 80}, "green1" } } },
	  { "Lib1", "", {320,  0,100,100}, "black" },
	  { "Lib2", "", {440,  0,100,100}, "black" } };


interface I
{
	void Write(int Value);

	/*** notes inside interface ***/
	note Name = "I";
	note Write.Complexity = 0;
	note Write.ArgType = "integer";
};

channel C(void) implements I
{
	int	Storage;
	bool	Valid;

	void Write(int Value)
	{
	/*** notes inside function ***/
	note Write.Name = "Write";
	note Value.Type = "int";

	l1: Storage = Value;
	l2: Valid = true;
	/*** notes inside statements ***/
	note Storage.Color = "green";
	note l1.OpID = 42;
	note l2.OpID = 42+1;
	}

	/*** notes inside channel ***/
	note Name = "C";	/* same as: note C.Name = "C"; */
	note Storage.Bytes = sizeof(int);
};

behavior B(in int p1, I p2)
{
	int square(int a)
	{
	int r;
		{ int t;
		  /*** notes in compound statements ***/
		  note t.comment = "t is temporary only";
		  statement1: t = a * a;
		  note statement1.cost = 32 * 32;
		  statement2: r = t; }
	statement3: return(r);
	}

	void main(void)
	{
	const int x = 5;
	int y;
	/*** notes inside function ***/
	note Name = "main";	/* same as: note main.Name = "main"; */
	note x.Bits = sizeof(int) * 16 / 2 + (-42)/6 + 7.0;

	label1: y = square(x);
	}
	enum { E_TEMPORARY, E_STANDARD, E_INLINED };

	/*** notes inside behavior ***/
	note B.Name = "B";
	note main.FullName = "B.main";
	note square.type = E_INLINED;
	note E_TEMPORARY.blablabla = "stupid note at enum";
};


/*** notes attached to interface/channel/behavior names ***/

note I.comment	= "This is an one-way interface.";
note C.cost	= 512.50;
note B.version	= 1.0;


/*** notes for aggregate types ***/

struct S
{
	int a, b;
	note a.bits	= sizeof(int) * 8;
	float f;
	note f.bits	= sizeof(float) * 8;
};

note S.comment	= "for demonstration only";
note S.bits	= sizeof(struct S) * 8;

typedef struct /* unnamed */ { float x, y, z; } Vector3D;
note Vector3D.bits = sizeof(Vector3D) * 8;


/*** notes inside 'fsmd' statements ***/

behavior FSMD(
	in  signal bool			CLK,
	in  signal bool			RST,
	in  signal unsigned bit[31:0]	Inport,
	in  signal unsigned bit[1]	Start,
	out signal unsigned bit[31:0]	Outport,
	out signal unsigned bit[1]	Done)
{
   note CLK.IsClockInput = true;
   note RST.IsActiveHi = false;

   void main(void)
   {
     fsmd(CLK rising; ; !RST)
	{ unsigned bit[31:0]	Data, Ocount, Mask, Temp;
	  note Data.IsRegister = true;

	  if (!RST)   { goto S0;
			l100: Outport = 0;
			note l100.ThisState = "reset state";
			Done = 0;
			note XXX = "attached to main method";
		       }
		      { note YYY = "attached to main method";
			l101: Outport = 0;
			note l101.ThisState = "default state";
			Done = 0;
			l102: ; note l102.check = "OK";
		       }
	  S0 :	      { note ThisState = "S0";
			if (Start)
			     goto S1;
			else
			     goto S0;
		       }
	  S1 :	      {	Data = Inport;
			note ThisState = "S1";
			goto S2;
		       }
	  S2 :	      {	Ocount = 0;
			goto S3;
			note ThisState = "S2";
		       }
	  S3 :	      { note S3.ThisState = "S3";
			Mask = 1;
			goto S4;
		       }
	  S4 :	      { Temp = Data & Mask;
			goto S5;
		       }
	  S5 :	      { note S5.ThisState = "S5";
			note S4.ThisState = "S4";
			Ocount += Temp;
			goto S6;
		       }
	  S6 :	      { l1: Data = Data >> 1;
			l2: if (Data == 0)
			    l3: goto S7;
			else
			    l4: goto S4;
			note l3.TargetState = "S7";
			note l4.TargetState = "S4";
		       }
	  S7 :	      { Outport = Ocount;
			Done = 1;
			if (Start)
			     S7: goto S7;
			else
			     goto S0;
			note S7.ThisState = "S7";
		       }
	 }
    }
};

// interesting bug with annotations at labeled if branch before else branch:
// (fixed 02/13/03, RD)

void LabeledIfBranchBeforeElse(bool b)
{
  l1: if (b)
	  l2: goto l3;
      else
	  l3: goto l4;
  l4: ;

  note l1.Note = "l1";
  note l2.Note = "l2";
  note l3.Note = "l3";
  note l4.Note = "l4";
}


/* EOF */
