// FSM6.sc:

#include "../../inc/sim.sh"	// <sim.sh>
#include <stdio.h>


behavior State4 (event clk)
{
    int		i=0;

    void main(void)
    {
	fsm{ S41
		{
		  printf("Time =%5s : State 4.1 active...\n", time2str(now()));
		  wait(clk);
		}
		: /* default: goto next state */
	     S42
		{
		  printf("Time =%5s : State 4.2 active...\n", time2str(now()));
		  wait(clk);
		}
		:
		{ if (++i < 2) goto S42;
		  goto S43;
		 }
	     S43
		{
		  printf("Time =%5s : State 4.3 active...\n", time2str(now()));
		  wait(clk);
		}
		:
		{ if (i=0, true) goto S44;
		  goto S43;
		  break;
		  goto S43;
		 }
	     S44
		{
		  printf("Time =%5s : State 4.4 active...\n", time2str(now()));
		  wait(clk);
		}
		:
		{ if (++i < 4) goto S44;
		  if (false) goto S44;
		  if (true) break;
		  goto S41;
		 }
	    }
    }
};

behavior FSM (event clk)
{
	bool	Condition1 = false,
		Condition2 = true;

	State4	S4(clk);

	void main(void)
	{
	fsm{ S1 {
		  printf("Time =%5s : State 1 active...\n", time2str(now()));
		  wait(clk);
		}
		: /* default: goto next state */

	     S2 {
		  printf("Time =%5s : State 2 active...\n", time2str(now()));
		  wait(clk);
		}
		:
		{ if (Condition1)
			goto S2;
		  /* else */
			goto S3;
		 }

	     S3 {
		  printf("Time =%5s : State 3 active...\n", time2str(now()));
		  wait(clk);
		}
		:
		{ if (Condition2 || Condition1)
			goto S4;
		  goto S2;
		 }

	     S4:
		{ /* default: goto next state */
		 }

	     S5 {
		  printf("Time =%5s : State 5 active...\n", time2str(now()));
		  wait(clk);
		}
		:
		{ if (Condition1)
			goto S4;
		  if (! Condition2)
			goto S5;
		 }

	     S6 {
		  printf("Time =%5s : State 6 active...\n", time2str(now()));
		  wait(clk);
		}
		:
		{ if (Condition1)
			goto S3;
		  if (Condition1 && !Condition2)
			goto S4;
		  break;
		 }
	    }
	}
};

behavior Clock (event clk)
{
	void main(void)
	{
	int	i;
	for(i=1; i<20; i++)
		{
		waitfor(100);
//		printf("Time =%5s : Clock-tick!\n", time2str(now()));
		notify(clk);
		}
	}
};

behavior Main
{
	event	SystemClock;
	Clock	ClockGen(SystemClock);
	FSM	MyFSM(SystemClock);

	int main(void)
	{
	puts("Starting...");
	par {	ClockGen.main();
		MyFSM.main();
		}
	puts("Exiting...");
	return(0);
	}
};

// EOF
