/*******************************************************************/
/* ArrayCopy2.sc: 2nd test program to check for array-copy feature */
/*******************************************************************/

/* last update: 05/21/01 by RD */


#include <stdio.h>
#include <assert.h>

// #define ENABLE_PRINTING


void test1(void)
{
int	A[3][5],
	B[3][5];
int	i,j;

puts("Test 1:");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { A[i][j] = i*10+j;
     B[i][j] = 100-(i*10+j);
    }

#ifdef ENABLE_PRINTING
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { printf("A[%d][%d] = %d, ", i, j, A[i][j]);
     printf("B[%d][%d] = %d\n", i, j, B[i][j]);
    }
#endif /* ENABLE_PRINTING */

puts("Array-copy: A = B;");
A = B;

#ifdef ENABLE_PRINTING
puts("Printing...");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { printf("A[%d][%d] = %d, ", i, j, A[i][j]);
     printf("B[%d][%d] = %d\n", i, j, B[i][j]);
    }
#endif /* ENABLE_PRINTING */

puts("Checking...");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { assert(A[i][j] == B[i][j]);
    }
puts("Test 1 done.\n");
}


void test2(void)
{
int	A[3][5],
	B[3][5];
int	i,j;

puts("Test 2:");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { A[i][j] = i*10+j;
     B[i][j] = 100-(i*10+j);
    }

#ifdef ENABLE_PRINTING
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { printf("A[%d][%d] = %d, ", i, j, A[i][j]);
     printf("B[%d][%d] = %d\n", i, j, B[i][j]);
    }
#endif /* ENABLE_PRINTING */

puts("Array-copy: A[1] = B[1];");
A[1] = B[1];

#ifdef ENABLE_PRINTING
puts("Printing...");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { printf("A[%d][%d] = %d, ", i, j, A[i][j]);
     printf("B[%d][%d] = %d\n", i, j, B[i][j]);
    }
#endif /* ENABLE_PRINTING */

puts("Checking...");
for(i=1;i<2;i++)
 for(j=0;j<5;j++)
   { assert(A[i][j] == B[i][j]);
    }
puts("Test 2 done.\n");
}


void test3(void)
{
int	A[3][5],
	B[3][5];
int	i,j;

puts("Test 3:");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { A[i][j] = i*10+j;
     B[i][j] = 100-(i*10+j);
    }

#ifdef ENABLE_PRINTING
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { printf("A[%d][%d] = %d, ", i, j, A[i][j]);
     printf("B[%d][%d] = %d\n", i, j, B[i][j]);
    }
#endif /* ENABLE_PRINTING */

puts("Array-copy: A[0] = B[1];");
A[0] = B[1];
puts("Array-copy: A[1] = B[2];");
A[1] = B[2];
puts("Array-copy: A[2] = B[0];");
A[2] = B[0];

#ifdef ENABLE_PRINTING
puts("Printing...");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { printf("A[%d][%d] = %d, ", i, j, A[i][j]);
     printf("B[%d][%d] = %d\n", i, j, B[i][j]);
    }
#endif /* ENABLE_PRINTING */

puts("Checking...");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { assert(A[i][j] == B[(i+1)%3][j]);
    }
puts("Test 3 done.\n");
}


void test4(void)
{
int	A[3][5],
	B[5];
int	i,j;

puts("Test 4:");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { A[i][j] = i*10+j;
    }
for(i=0;i<3;i++)
   { B[i] = -1;
    }

#ifdef ENABLE_PRINTING
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { printf("A[%d][%d] = %d, ", i, j, A[i][j]);
    }
for(i=0;i<3;i++)
   { printf("B[%d] = %d, ", i, B[i]);
    }
#endif /* ENABLE_PRINTING */

puts("Array-copy: B = A[0];");
B = A[0];
puts("Array-copy: A[0] = A[1];");
A[0] = A[1];
puts("Array-copy: A[1] = A[2];");
A[1] = A[2];
puts("Array-copy: A[2] = B;");
A[2] = B;

#ifdef ENABLE_PRINTING
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { printf("A[%d][%d] = %d, ", i, j, A[i][j]);
    }
for(i=0;i<3;i++)
   { printf("B[%d] = %d, ", i, B[i]);
    }
#endif /* ENABLE_PRINTING */

puts("Checking...");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { assert(A[i][j] == ((i+1)%3)*10+j);
    }
puts("Test 4 done.\n");
}


void test5(void)
{
int	A[3][5],
	B[3][5],
	C[3][5];
int	i,j;

puts("Test 5:");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { A[i][j] = i*10+j;
     B[i][j] = 100-(i*10+j);
     C[i][j] = -1;
    }

#ifdef ENABLE_PRINTING
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { printf("A[%d][%d] = %d, ", i, j, A[i][j]);
     printf("B[%d][%d] = %d\n", i, j, B[i][j]);
     printf("C[%d][%d] = %d\n", i, j, C[i][j]);
    }
#endif /* ENABLE_PRINTING */

//puts("Array-copy: A = B = C;");	/* NOT SUPPORTED! */
//A = B = C;			/* result type of array assignment is 'void' */
puts("Array-copy: B = C; A = B;");
B = C; A = B;

#ifdef ENABLE_PRINTING
puts("Printing...");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { printf("A[%d][%d] = %d, ", i, j, A[i][j]);
     printf("B[%d][%d] = %d\n", i, j, B[i][j]);
     printf("C[%d][%d] = %d\n", i, j, C[i][j]);
    }
#endif /* ENABLE_PRINTING */

puts("Checking...");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { assert(A[i][j] == B[i][j]);
     assert(B[i][j] == C[i][j]);
     assert(C[i][j] == A[i][j]);
    }
puts("Test 5 done.\n");
}

void test6(void)
{
long long	A[3][5],
		B[3][5];
int		i,j;

puts("Test 6:");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { A[i][j] = i*10+j;
     B[i][j] = 100-(i*10+j);
    }

#ifdef ENABLE_PRINTING
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { printf("A[%d][%d] = %d, ", i, j, (int)A[i][j]);
     printf("B[%d][%d] = %d\n", i, j, (int)B[i][j]);
    }
#endif /* ENABLE_PRINTING */

puts("Array-copy: A = B;");
A = B;

#ifdef ENABLE_PRINTING
puts("Printing...");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { printf("A[%d][%d] = %d, ", i, j, (int)A[i][j]);
     printf("B[%d][%d] = %d\n", i, j, (int)B[i][j]);
    }
#endif /* ENABLE_PRINTING */

puts("Checking...");
for(i=0;i<3;i++)
 for(j=0;j<5;j++)
   { assert(A[i][j] == B[i][j]);
    }
puts("Test 6 done.\n");
}

void f(int A[][10])
{
int B[10][10];

B[1] = A[2];
}

#ifdef __SPECC__
behavior Main
{
#endif /* __SPECC__ */

int main(void)
{
test1();
test2();
test3();
test4();
test5();
test6();

return(0);
}

#ifdef __SPECC__
};
#endif /* __SPECC__ */


/* EOF */
