/************************************************************************/
/* IntRep/Event.h: SpecC Internal Representation, Event Classes		*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 11/21/02 */
/************************************************************************/

/* last update: 09/26/06 */

/* modifications: (most recent first)
 *
 * 09/26/06 PC  Adjustments for scrc 2.1
 * 06/03/05 RD	reorganized and renamed global type names
 * 06/15/04 PC  Adjustments for scrc 2.0
 * 12/18/02 RD	added SIR_Events::WriteCC() method (writes recursive list)
 * 11/26/02 RD	added C++ code generation for edges of signals
 * 11/25/02 RD	added support for triggering edges of signals
 * 11/21/02 RD	initial version (separated from Symbol.h)
 */

#ifndef INTREP_EVENT_H
#define INTREP_EVENT_H


#include "Global.h"
#include "IntRep/List.h"


/*** constants and macros ***********************************************/


	/* (none) */


/*** enumeration types **************************************************/


enum SIR_SignalEdge		/* type of edge for a signal event */
{
SIR_EDGE_ANY,
SIR_EDGE_FALLING,
SIR_EDGE_RISING
};


/*** type definitions ***************************************************/


typedef enum SIR_SignalEdge		SIR_EDGE;

typedef class SIR_Event			sir_event;
typedef SIR_List<sir_event>		sir_event_list;
typedef class SIR_Events		sir_events;
typedef struct SIR_EventRep		sir_event_rep;

typedef class SIR_Symbol		sir_symbol;	/* cyclic link */

typedef class SIR_PortVar		sir_portvar;	/* cyclic link */


/*** class declarations *************************************************/


	/*****************/
	/*** SIR_Event ***/
	/*****************/


class SIR_Event :		/* (pointer to) an event (or a signal) */
	public SIR_ListElem<SIR_Event>	/* is a list element */
{
public:
sir_symbol	*Symbol;	/* link to the symbol */
SIR_EDGE	Edge;		/* triggering edge of signal */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Event(			/* constructor #1 */
	sir_symbol	*Symbol,
	SIR_EDGE	Edge = SIR_EDGE_ANY);

SIR_Event(			/* constructor #3 (duplicator) */
	sir_event	*Original);

~SIR_Event(void);		/* destructor */

ERROR WriteSC(			/* (re-) generates SpecC source code */
	gl_io		*IO,
	bool		CplusplusMode = false);

sir_event *Copy(void);          /* creates an exact copy of the event */
                                /* (returns NULL if SIR_Error) */

void Delete(void);              /* deletes the event (or signal) */

bool IsSignal(                  /* is a signal (true) or pure event (false) */
        void);

sir_symbol *GetSymbol(          /* obtain the symbol */
        void);

SIR_EDGE GetEdge(               /* obtain the triggering edge for the signal */
        void);
};


	/******************/
	/*** SIR_Events ***/
	/******************/


class SIR_Events :		/* list of event (or signal) pointers */
	public SIR_List<SIR_Event>	/* is basically a list */
{					/* with additional functions */
public:

//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Events(			/* constructor #1 */
	sir_event	*FirstEntry = NULL);

SIR_Events(			/* constructor #2 (duplicator) */
	sir_events	*Original);

~SIR_Events(void);		/* destructor */

void UnAlias(void);		/* unalias all type, usertype, symbol links */


ERROR WriteSC(			/* (re-) generates SpecC source code */
	gl_io		*IO,
	const char	*Separator = ",",
	bool		CplusplusMode = false);

ERROR WriteCC(			/* generates (recursive) C++ code */
	gl_io		*IO);

sir_event *Find(                /* searches for a specific entry */
        sir_symbol      *Symbol);       /* (returns NULL if not found) */

};


#endif /* INTREP_EVENT_H */

/* EOF IntRep/Event.h */
