/************************************************************************/
/* IntRep/Constraint.h: SpecC Internal Representation, Constraint Class	*/
/************************************************************************/
/* Author: Rainer Doemer			first version: 10/20/97 */
/************************************************************************/

/* last update: 06/15/04 */

/* modifications: (most recent first)
 *
 * 06/15/04 PC  Adjustments for scrc 2.0
 * 05/30/01 RD	eliminated level 2 of SIR API
 * 05/25/01 RD	eliminated support for binary SIR files (import/export)
 * 04/06/01 RD	added support for non-native 'long long' type;
 *		changed use of 'long long int' to TIME type
 * 04/06/01 RD	started this header (last update was 04/12/99)
 */

#ifndef INTREP_CONSTRAINT_H
#define INTREP_CONSTRAINT_H


#include "Global.h"
#include "IntRep/Label.h"


/*** enumeration types **************************************************/


	/* none */


/*** type definitions ***************************************************/


typedef class SIR_Constraint		sir_constraint;
typedef SIR_List<sir_constraint>	sir_constraint_list;
typedef class SIR_Constraints		sir_constraints;


/*** class declarations *************************************************/


	/**********************/
	/*** SIR_Constraint ***/
	/**********************/


class SIR_Constraint :		/* constraint */
	public SIR_Node,			/* is a node */
	public SIR_ListElem<SIR_Constraint>	/* and a list element */
{
public:
sir_label	*Label1;	/* first label entry */
sir_label	*Label2;	/* second label entry */
sir_constant	*MinTime;	/* minimum time (NULL if unspecified) */
sir_constant	*MaxTime;	/* maximum time (NULL if unspecified) */


//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Constraint(			/* constructor #1 */
	sir_label	*Label1,
	sir_label	*Label2,
	sir_constant	*MinTime,
	sir_constant	*MaxTime,
	unsigned int	Line = 0,
	sir_fileinfo	*FileInfo = NULL);

SIR_Constraint(			/* constructor #3 (duplicator) */
	sir_constraint	*Original);

~SIR_Constraint(void);		/* destructor */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);
};


	/***********************/
	/*** SIR_Constraints ***/
	/***********************/


class SIR_Constraints :		/* constraints list */
	public SIR_List<SIR_Constraint>	/* is simply a list of constraints */
{					/* with additional member(function)s */
public:

//++++++++++++++++++++++++++++ API Layer 1 +++++++++++++++++++++++++++++//


SIR_Constraints(		/* constructor #1 */
	sir_constraint	*FirstEntry = NULL);

SIR_Constraints(		/* constructor #2 (duplicator) */
	sir_constraints	*Original);

~SIR_Constraints(void);		/* destructor */


ERROR DFS_ForAllNodes(		/* iterator over all nodes (depth first) */
	sir_node_mptr	MemberFct,
	sir_node_marg	MemberFctArg);


sir_constraint *Insert(		/* insert a new constraint */
	sir_constraint	*NewOne);	/* (must not exist) */

sir_constraint *Find(		/* find the first constraint beginning here */
	sir_label	*Label1);	/* (returns NULL if not found) */

sir_constraint *Find(		/* find a constraint */
	sir_label	*Label1,	/* (returns NULL if not found) */
	sir_label	*Label2);
};


/*** exported functions *************************************************/


	/* none */


#endif /* INTREP_CONSTRAINT_H */

/* EOF IntRep/Constraint.h */
